package processo;

import java.util.Random;

import officina.EccezionePrecondizioni;
import officina.Riparazione;
import _framework.Executor;
import _framework.Task;

/**
 * Implementa il task "Acquista i pezzi necessari" che simula
 * la connessione con il sistema automatico per l'acquisto dei pezzi
 */
public class AcquistaPezzi implements Task 
{
	Riparazione riparazione;
	private static final float MAX_IMPORTO=1000;
	
	public AcquistaPezzi(Riparazione ripa) 
	{
		this.riparazione=ripa;
	}

	public synchronized void esegui(Executor e) 
	{
		if (riparazione.getImporto()>0)
			return;
		System.out.println("Simulato l'acquisto dei pezzi...");
		try {
			riparazione.setImporto(new Random().nextFloat()*MAX_IMPORTO);
		} catch (EccezionePrecondizioni e1) {
			e1.printStackTrace();
		}
	}

}
