package officina;

import java.util.Date;

public class Riparazione 
{
	private float importo=0;
	private String descrizione="";
	private boolean carrozzeriaDanneggiata=false;
	private boolean meccanicaDanneggiata=false;
	private final Date aperturaPratica=new Date();
	private TipoLinkCoinvolto link=null;
	
	public float getImporto() 
	{
		return importo;
	}
	
	public void setImporto(float importo) throws EccezionePrecondizioni 
	{
		if (importo<0)
			throw(new EccezionePrecondizioni("Impossibile che l'importo sia un valore negativo"));
		this.importo = importo;
	}
	
	public String getDescrizione() {
		return descrizione;
	}
	public void setDescrizione(String descrizione) throws EccezionePrecondizioni 
	{
		if (descrizione==null)
			throw(new EccezionePrecondizioni("Impossibile che la descrizione sia NULL"));
		this.descrizione = descrizione;
	}

	public boolean isCarrozzeriaDanneggiata() {
		return carrozzeriaDanneggiata;
	}

	public void setCarrozzeriaDanneggiata(boolean carrozzeriaDanneggiata) {
		this.carrozzeriaDanneggiata = carrozzeriaDanneggiata;
	}

	public boolean isMeccanicaDanneggiata() {
		return meccanicaDanneggiata;
	}

	public void setMeccanicaDanneggiata(boolean meccanicaDanneggiata) {
		this.meccanicaDanneggiata = meccanicaDanneggiata;
	}

	public Date getAperturaPratica() {
		return aperturaPratica;
	}

	public void inserisciLinkPerManagerCoinvolto(ManagerCoinvolto manager) {
		if (manager!=null)
			link=manager.getLink();		
	}

	public TipoLinkCoinvolto getLink() throws EccezioneCardMinMax 
	{
		if (link==null)
			throw(new EccezioneCardMinMax("Eccezione cardinalit minima"));	
		return link;
	}
	
	
	
	
}
