package it.uniroma1.dis.PS;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;

public class Polygon extends Figure 
{
	private Color fillColor=null;
	private java.awt.Polygon shape=new java.awt.Polygon();
	private Point[] pointsArray;
	private boolean closePolygon;
	
	private void createShape()
	{
		shape.reset();
		if (pointsArray!=null && pointsArray.length>0)
		{
			for(int i=0;i<pointsArray.length;i++)
			{
				shape.addPoint((int)pointsArray[i].getX(), (int)pointsArray[i].getY());
			}
			if (closePolygon)
				shape.addPoint((int)pointsArray[0].getX(), (int)pointsArray[0].getY());				
		}
			
	}
	
	public Polygon(Point[] pointsArray,boolean closePolygon)
	{
		this.pointsArray=pointsArray.clone();
		createShape();
		this.closePolygon=closePolygon;
	}
	
	public void draw(Graphics2D g2d) 
	{
		if (shape!=null)
		{
			g2d.setColor(this.lineColor);
			g2d.setStroke(new BasicStroke(this.lineSize));			
			g2d.draw(shape);
			if (fillColor!=null)
			{
				g2d.setColor(this.fillColor);
				g2d.fill(shape);
			}
		}
	}
	
	public boolean containsPoint(Point p)
	{
		return(shape.contains(p.getX(), p.getY()));
	}

	public void setFillColor(Color fillColor) 
	{
		this.fillColor = fillColor;
	}

	public Color getFillColor() {
		return fillColor;
	}

}
