package goldSeeker;

public class TipoLinkRaccolto 
{
	private final SacchettoOro sacchetto;
	private final Cercatore cercatore;

	public TipoLinkRaccolto(SacchettoOro sacchetto,Cercatore cercatore) throws EccezionePrecondizioni
	{
		if (sacchetto!=null && cercatore!=null)
		{
			this.sacchetto=sacchetto;
			this.cercatore=cercatore;
		}
		else
			throw(new EccezionePrecondizioni("Gli oggetti devono essere inizializzati"));
	}
	
	public SacchettoOro getSacchettoOro() {
		return sacchetto;
	}
	public Cercatore getCercatore() {
		return cercatore;
	}

	public int hashCode() 
	{
		return cercatore.hashCode()+sacchetto.hashCode();
	}

	public boolean equals(Object obj) {
		if (obj==null || getClass() != obj.getClass())
			return false;
		else
		{
			TipoLinkRaccolto other = (TipoLinkRaccolto) obj;
			if (cercatore!=other.cercatore || sacchetto!= other.sacchetto)
				return false;
			else
				return true;
		}
	}
}
