package goldSeeker;
import gestioneeventi.*;

import java.util.*;

public abstract class Cercatore extends Elemento implements Listener
{
	private final String nome;
	
	
	//Costanti
	protected final double costoPasso= 0.5;
	protected final double ricaricaAcqua=10;
	protected final double  acquaIniziale=5;
	
	// Variabili di Stato
	private enum Stato {DISSETATO,DISIDRATATO,NONINGIOCO};
	private Stato statoCorrente = Stato.NONINGIOCO;
	protected double acqua;
	
	private HashSet<TipoLinkRaccolto> links=new HashSet<TipoLinkRaccolto>();
	
	public Cercatore(String nome){
		this.nome=nome;
	}
	
	public void inserisciPerManagerRaccolto(ManagerRaccolto k) 
	{
		if (k!=null)
			links.add(k.getLink());
	}

	public void eliminaPerManagerRaccolto(ManagerRaccolto k) 
	{
		links.remove(k.getLink());
		
	}
	
	@SuppressWarnings("unchecked")
	public Set<TipoLinkRaccolto> getLinks()
	{
		return((Set<TipoLinkRaccolto>)links.clone());
	}

	// Il comportamento dei seguenti metodi dipende dall'effettiva classe che li implementa
	protected abstract void vaiAcqua();
	protected abstract void vaiOro();
	
	// fired() coordina l'esecuzinoe dei metodi sopra, in dipendenza dallo stato corrente, dagli eventi e dalle condizioni
	public Evento fired(Evento e){
		if (e.getDestinatario()!=this && e.getDestinatario()!= null){
			//Messaggio non indirizzato all'oggetto o non in broadcasting
			return null;
		}
		Evento nuovoEvento = null;
		switch(statoCorrente){
			case NONINGIOCO:
				if (e.getClass() == InizioGioco.class) {
					acqua = acquaIniziale;
					statoCorrente = Stato.DISSETATO;
					nuovoEvento = new Evento(this,this);
				}
			break;
			case DISSETATO:
				if (e.getClass() == Evento.class) {
					if (oroFinito()){
						statoCorrente = Stato.NONINGIOCO;
					}
					else{
						if (acqua>0){
							vaiOro();
							statoCorrente = Stato.DISSETATO;
						}
						else{
							vaiAcqua();
							statoCorrente = Stato.DISIDRATATO;
						}
						acqua -= costoPasso;
						if (pozzoRaggiunto())
							ripristinaAcqua();
						if (oroRaggiunto())
							raccogliOro();
						nuovoEvento = new Evento(this,this);
					}
				}
				break;
			case DISIDRATATO:
				if (e.getClass() == Evento.class) {
					if (oroFinito()){
						statoCorrente = Stato.NONINGIOCO;						
					}
					else{
						if (acqua>0){
							vaiOro();
							statoCorrente = Stato.DISSETATO;
						}
						else{
							vaiAcqua();
							statoCorrente = Stato.DISIDRATATO;						
						}
						acqua -= costoPasso;
						if (pozzoRaggiunto())
							ripristinaAcqua();
						if (oroRaggiunto())
							raccogliOro();
						nuovoEvento = new Evento(this,this);
					}
				}				
				break;
			default:
				throw new RuntimeException("Stato corrente non riconosciuto.");
		}
		return nuovoEvento;
	}
	
	// Metodi ausiliari:
	
	protected void ripristinaAcqua(){
			acqua = ricaricaAcqua;
	}

	protected void raccogliOro(){
		// Puo' essere chiamato solo se il cercatore occupa una casella contenente un sacchetto d'oro
		try{
			Casella miaCasella = getLinkOspita().getCasella();
			Iterator<TipoLinkOspita> iterOspita = miaCasella.getLinkOspita().iterator();
			SacchettoOro e = null;
			while(e == null & iterOspita.hasNext()){
				TipoLinkOspita linkCorrente = iterOspita.next();
				if (linkCorrente.getElemento().getClass() == SacchettoOro.class)
					e = (SacchettoOro) linkCorrente.getElemento();
			}
			// Elimina il link tra la casella ed il sacchetto d'oro
			ManagerOspita.elimina(new TipoLinkOspita(e,miaCasella));
			// Aggiunge un link raccolto tra il cercatore ed il sacchetto d'oro
			ManagerRaccolto.inserisci(new TipoLinkRaccolto(e, this));
		}
		catch(EccezioneCardMinMax e){
			e.printStackTrace();
			System.exit(1);
		}
		catch(EccezionePrecondizioni e){
			e.printStackTrace();
			System.exit(1);
		}
	}
	
	protected boolean pozzoRaggiunto(){//Restituisce true sse il Cercatore occupa una casella che ospita un pozzo
		Casella miaCasella = null;
		boolean pozzo = false;
		try{
			miaCasella=getLinkOspita().getCasella();
			Iterator<TipoLinkOspita> iterOspita = miaCasella.getLinkOspita().iterator();
			while(!pozzo && iterOspita.hasNext()){
				if (iterOspita.next().getElemento().getClass() == Pozzo.class)
					pozzo = true;
			}
		}
		catch(EccezioneCardMinMax e){
			e.printStackTrace();
			System.exit(1);
		}
		return pozzo;
	}
	
	protected boolean oroRaggiunto(){//Restituisce true sse il Cercatore occupa una casella che ospita un pozzo
		Casella miaCasella = null;
		boolean oro = false;
		try{
			miaCasella=getLinkOspita().getCasella();
			Iterator<TipoLinkOspita> iterOspita = miaCasella.getLinkOspita().iterator();
			while(!oro && iterOspita.hasNext()){
				if (iterOspita.next().getElemento().getClass() == SacchettoOro.class)
					oro = true;
			}
		}
		catch(EccezioneCardMinMax e){
			e.printStackTrace();
			System.exit(1);
		}
		return oro;
	}

	
	protected boolean oroFinito(){//Restituisce true sse no c'e' piu'oro nelle caselle
		//Effettua una visita esaustiva di tutta la mappa e ritorna false appena trova un sacchetto d'oro
		
		// Insieme delle caselle da visitare
		Set<Casella> caselleDaVisitare = new HashSet<Casella>();
		// Inizializza le caselle da visitare alla casella che ospita l'oggetto di invocazione
		try{
			caselleDaVisitare.add(getLinkOspita().getCasella());
		}
		catch(EccezioneCardMinMax e){
			e.printStackTrace();
			System.exit(1);
		}
		// Insieme delle caselle visitate
		Set<Casella> caselleVisitate = new HashSet<Casella>();
		while(!caselleDaVisitare.isEmpty()){
			// Estrae una casella da visitare
			Casella casellaCorrente = caselleDaVisitare.iterator().next();
			caselleDaVisitare.remove(casellaCorrente);
			// Verifica se la casella corrente contiene oro
			Set<TipoLinkOspita> linksOspita = casellaCorrente.getLinkOspita();
			Iterator<TipoLinkOspita> iterLinkOspita = linksOspita.iterator();
			while(iterLinkOspita.hasNext()){
				if (iterLinkOspita.next().getElemento().getClass() == SacchettoOro.class){
					return false;
				}
			}
			// Se la casella corrente non contiene oro...
			// Aggiorna l'insieme da visitare con le caselle adiacenti a quella corrente, non ancora visitate
			// Nord
			if (casellaCorrente.getLinkNord()!= null && !caselleVisitate.contains(casellaCorrente.getLinkNord().getCasellaNord())){
				caselleDaVisitare.add(casellaCorrente.getLinkNord().getCasellaNord());
			}
			// Est
			if (casellaCorrente.getLinkEst()!= null && !caselleVisitate.contains(casellaCorrente.getLinkEst().getCasellaEst())){
				caselleDaVisitare.add(casellaCorrente.getLinkEst().getCasellaEst());
			}
			// Sud
			if (casellaCorrente.getLinkSud()!= null && !caselleVisitate.contains(casellaCorrente.getLinkSud().getCasellaSud())){
				caselleDaVisitare.add(casellaCorrente.getLinkSud().getCasellaSud());
			}
			// Ovest
			if (casellaCorrente.getLinkOvest()!= null && !caselleVisitate.contains(casellaCorrente.getLinkOvest().getCasellaOvest())){
				caselleDaVisitare.add(casellaCorrente.getLinkOvest().getCasellaOvest());
			}
			caselleVisitate.add(casellaCorrente);
		}// while(!caselleDaVisitare.isEmpty())
		return true;
	}

	public String getNome() {
		return nome;
	}
	
}
