package applicazione;

import goldSeeker.*;
import gestioneeventi.*;

import java.util.*;

import GUI.MainWindow;
import javax.swing.*;
public class Main
{
	private static final int LATOGRIGLIA = new Random().nextInt(11)+10; // random da 10 a 20
	private static final int NAUTONOMI = new Random().nextInt(3)+1; // random da 1 a 3
	private static final int NCONTROLLATI = 1; 
	
	public static void main(String args[]) throws EccezionePrecondizioni, EccezioneInvarianti
	{
		int continuaGioco = JOptionPane.YES_OPTION;
		while(continuaGioco == JOptionPane.YES_OPTION){
			ControlloreGioco i=new ControlloreGioco();
			creaQuadroRandom(i,LATOGRIGLIA,NAUTONOMI,NCONTROLLATI);
			// Prepara l'environment
			Environment env = new Environment();
			Set<Casella> caselleMappa = i.getLinks();
			Iterator<Casella> iterCasella = caselleMappa.iterator();
			while(iterCasella.hasNext()){
					Iterator<TipoLinkOspita> iterOspita = iterCasella.next().getLinkOspita().iterator();
					while(iterOspita.hasNext()){
						Elemento elementoCorrente = iterOspita.next().getElemento();
						if (elementoCorrente instanceof Cercatore){
							Cercatore c = (Cercatore) elementoCorrente;
							env.addListener(c);
							env.aggiungiEvento(new InizioGioco(null,c));
						}
					}
			}
			//
			MainWindow finestra=new MainWindow(i);
			i.setFinestra(finestra);
			env.eseguiEnvironment();
			
			continuaGioco = JOptionPane.showConfirmDialog(null,"La partita  finita, vuoi giocare ancora?","",JOptionPane.YES_NO_OPTION);
			i.setFinestra(null);
			finestra.dispose();
		}
		System.exit(0);
	}
	
	public static void stampaMappa(ControlloreGioco m)
	{
		// Funzione Ausiliaria che stampa una mappa
		// (da elimiare dopo aver creato l'interfaccia grafica)
		Casella [][] matrice = m.trasformaInMatrice();
		for (int i = matrice.length-1; i >= 0 ; i--)
		{
			for (int j = 0; j < matrice[i].length; j++){
				String carattere = " ";
				if (matrice[i][j]!=null && matrice[i][j].getLinkNord()!= null){
					carattere = "|";
				}
				System.out.print(carattere+" ");
			}
			System.out.println();			
			for (int j = 0; j < matrice[i].length; j++){
				String carattere = " ";
				String estConn=" ";
				if (matrice[i][j]!=null){
					carattere = "x";
					if (matrice[i][j].getLinkEst()!=null){
						estConn = "-";
					}
				}				
				System.out.print(carattere+estConn);
			}
			System.out.println();					
		}
	}
	
	private static void creaQuadroRandom(ControlloreGioco m, int latoGriglia, int nAutonomi, int nControllati) throws EccezionePrecondizioni{
		Random generatore = new Random();
		int caselleAggiunte=0;
		Casella[][] griglia = new Casella[latoGriglia][latoGriglia];
		for (int i = 0; i < latoGriglia; i++)
			for (int j=0; j < latoGriglia; j++){
				griglia[i][j]=null;
			}
		int i = 0, j= 0;
		griglia[i][j] = new Casella();
		m.inserisciCasella(griglia[i][j]);
		
		final int nord = 0;
		final int est = 1;
		final int sud = 2;
		final int ovest = 3;
		while (caselleAggiunte < latoGriglia*latoGriglia/2){
			
			int dir = generatore.nextInt(4);
			if(dir == nord && i<latoGriglia-1){
				if(griglia[i+1][j] == null){
					griglia[i+1][j]=new Casella();
					m.inserisciCasella(griglia[i+1][j]);
				}
				ManagerLatitudine.inserisci(new TipoLinkLatitudine(griglia[i+1][j],griglia[i][j]));
				caselleAggiunte++;
				i++;
			}
			if(dir == est && j<latoGriglia-1){
				if(griglia[i][j+1] == null){
					griglia[i][j+1]=new Casella();
					m.inserisciCasella(griglia[i][j+1]);
				}
				ManagerLongitudine.inserisci(new TipoLinkLongitudine(griglia[i][j+1],griglia[i][j]));
				caselleAggiunte++;
				j++;
			}
			if(dir == sud && i>1){
				if(griglia[i-1][j] == null){
					griglia[i-1][j]=new Casella();
					m.inserisciCasella(griglia[i-1][j]);
				}
				ManagerLatitudine.inserisci(new TipoLinkLatitudine(griglia[i][j],griglia[i-1][j]));
				caselleAggiunte++;
				i--;
			}
			if(dir == ovest && j>1){
				if(griglia[i][j-1] == null){
					griglia[i][j-1]=new Casella();
					m.inserisciCasella(griglia[i][j-1]);
				}
				ManagerLongitudine.inserisci(new TipoLinkLongitudine(griglia[i][j],griglia[i][j-1]));
				caselleAggiunte++;
				j--;
			}
			if (generatore.nextInt(latoGriglia)==1 && nAutonomi > 0){
				ManagerOspita.inserisci(new TipoLinkOspita(new CercatoreAutonomo("CA"+nAutonomi, m), griglia[i][j]));
				nAutonomi--;
			}
			if (generatore.nextInt(latoGriglia*2)==1)
				ManagerOspita.inserisci(new TipoLinkOspita(new SacchettoOro(5), griglia[i][j]));
			if (generatore.nextInt(latoGriglia*3)==1)
				ManagerOspita.inserisci(new TipoLinkOspita(new Pozzo(), griglia[i][j]));
			if (generatore.nextInt(latoGriglia)==1 && nControllati>0){
				ManagerOspita.inserisci(new TipoLinkOspita(new CercatoreControllato("Pippo", m), griglia[i][j]));
				nControllati--;
			}
		}// while
	}

	private static ControlloreGioco creaControllore() throws EccezionePrecondizioni
	{
		ControlloreGioco m=new ControlloreGioco();
		//creaQuadroRandom(m);
		/*
		Casella[] caselle = new Casella[numCaselle];
		// Associa tutte le caselle alla mappa m
		for (int i=0;i<numCaselle;i++)
		{
			caselle[i]=new Casella();
			m.inserisciCasella(caselle[i]);
		}
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[1],caselle[0]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[2],caselle[1]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[6],caselle[2]));
		ManagerLatitudine.inserisci(new TipoLinkLatitudine(caselle[3],caselle[2]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[4],caselle[3]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[5],caselle[4]));
		ManagerLatitudine.inserisci(new TipoLinkLatitudine(caselle[5],caselle[7]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[7],caselle[6]));
		ManagerLatitudine.inserisci(new TipoLinkLatitudine(caselle[6],caselle[8]));
		ManagerLatitudine.inserisci(new TipoLinkLatitudine(caselle[8],caselle[9]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[10],caselle[8]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[11],caselle[10]));
		ManagerLatitudine.inserisci(new TipoLinkLatitudine(caselle[12],caselle[11]));
		ManagerLatitudine.inserisci(new TipoLinkLatitudine(caselle[13],caselle[12]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[13],caselle[5]));

		ManagerOspita.inserisci(new TipoLinkOspita(new Pozzo(), caselle[12]));
		ManagerOspita.inserisci(new TipoLinkOspita(new Pozzo(), caselle[0]));
		ManagerOspita.inserisci(new TipoLinkOspita(new Pozzo(), caselle[6]));
		
		ManagerOspita.inserisci(new TipoLinkOspita(new SacchettoOro(15), caselle[7]));
		ManagerOspita.inserisci(new TipoLinkOspita(new SacchettoOro(8), caselle[1]));
		ManagerOspita.inserisci(new TipoLinkOspita(new SacchettoOro(3), caselle[9]));
		
		ManagerOspita.inserisci(new TipoLinkOspita(new CercatoreAutonomo("Topolino", m), caselle[8]));
		//ManagerOspita.inserisci(new TipoLinkOspita(new CercatoreAutonomo("Pluto", m), caselle[11]));
		//ManagerOspita.inserisci(new TipoLinkOspita(new CercatoreAutonomo("Minnie", m), caselle[4]));
		ManagerOspita.inserisci(new TipoLinkOspita(new CercatoreControllato("Pluto",m), caselle[11]));
		*/
		return m;
	}
	private Main(){}
}
