package GUI;

import java.awt.BorderLayout;

import goldSeeker.CercatoreControllato;

import javax.swing.*;

import applicazione.ControlloreGioco;

public class MainWindow extends JFrame
{
	private JButton nordBtn=new JButton("Nord");
	private JButton sudBtn=new JButton("Sud");
	private JButton estBtn=new JButton("Est");
	private JButton ovestBtn=new JButton("Ovest");
	private MappaPanel pannello;
	private CercatoreControllato cercatore;
	private ControlloreGioco inter;
	private GuiListener ascoltatore=new GuiListener(this);
	
	public void abilitaMovimento(CercatoreControllato c)
	{
		nordBtn.setEnabled(true);
		sudBtn.setEnabled(true);
		estBtn.setEnabled(true);
		ovestBtn.setEnabled(true);
		cercatore=c;
	}
	
	public void aggiorna()
	{
		pannello.aggiorna();
	}
	
	public void disabilitaMovimento()
	{
		nordBtn.setEnabled(false);
		sudBtn.setEnabled(false);
		estBtn.setEnabled(false);
		ovestBtn.setEnabled(false);		
		cercatore=null;
	}
	
	public MainWindow(ControlloreGioco i)
	{
		super("GoldSeeker");
		pannello=new MappaPanel(i);
		this.getContentPane().add(nordBtn,BorderLayout.NORTH);
		this.getContentPane().add(sudBtn,BorderLayout.SOUTH);
		this.getContentPane().add(estBtn,BorderLayout.EAST);
		this.getContentPane().add(ovestBtn,BorderLayout.WEST);
		this.getContentPane().add(pannello,BorderLayout.CENTER);
		nordBtn.setEnabled(false);
		nordBtn.addActionListener(ascoltatore);
		nordBtn.setActionCommand(GuiListener.NORD);
		sudBtn.setEnabled(false);
		sudBtn.addActionListener(ascoltatore);
		sudBtn.setActionCommand(GuiListener.SUD);
		ovestBtn.setEnabled(false);
		ovestBtn.addActionListener(ascoltatore);
		ovestBtn.setActionCommand(GuiListener.OVEST);
		estBtn.setEnabled(false);
		estBtn.addActionListener(ascoltatore);
		estBtn.setActionCommand(GuiListener.EST);
		pack();
		setVisible(true);
		this.setDefaultCloseOperation(EXIT_ON_CLOSE);
		inter=i;
	}

	public CercatoreControllato getCercatore() {
		return cercatore;
	}

	public ControlloreGioco getInterfacciaGrafica() 
	{
		return inter;
	}
}
