package goldSeeker;

public class TipoLinkOspita 
{
	private final Elemento elem;
	private final Casella casella;

	public TipoLinkOspita(Elemento elem,Casella casella) throws EccezionePrecondizioni
	{
		if (elem!=null && casella!=null)
		{
			this.elem=elem;
			this.casella=casella;
		}
		else
			throw(new EccezionePrecondizioni("Gli oggetti devono essere inizializzati"));
	}
	
	public Elemento getElemento() {
		return elem;
	}
	
	public Casella getCasella() {
		/*Se vogliamo verificare l'invariante:
		 if (!casella.invariante()){
			throw new EccezioneInvarianti("Violazione invarianti");
		}
		*/
		return casella;
	}

	public int hashCode() 
	{
		return casella.hashCode()+elem.hashCode();
	}

	public boolean equals(Object obj) {
		if (obj==null || getClass() != obj.getClass())
			return false;
		else
		{
			TipoLinkOspita other = (TipoLinkOspita) obj;
			if (casella!=other.casella || elem!= other.elem)
				return false;
			else
				return true;
		}
	}
}
