package goldSeeker;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import applicazione.ControlloreGioco;
import GUI.*;

public class CercatoreAutonomo extends Cercatore {
	
	private ControlloreGioco contr;
	
	public CercatoreAutonomo(String nome, ControlloreGioco contr){
		super(nome);
		this.contr = contr;
	}
	
	@Override
	protected void vaiAcqua() {
		// Richiede al controllore di spostarlo in una delle caselle adiacenti che siano a distanza minima da un pozzo
		/*Da Completare*/
	}

	@Override
	protected void vaiOro() {
		// Calcola la casella adiacente pi vicina ad un sacchetto d'oro
		Casella nord=null, est=null, sud=null, ovest=null;
		Casella minDist = null;
		try{
			Casella miaCasella = getLinkOspita().getCasella();
			if (miaCasella.getLinkNord()!= null)
				nord = miaCasella.getLinkNord().getCasellaNord();
			if (miaCasella.getLinkEst()!= null)
				est = miaCasella.getLinkEst().getCasellaEst();
			if (miaCasella.getLinkSud()!= null)
				sud = miaCasella.getLinkSud().getCasellaSud();
			if (miaCasella.getLinkOvest()!= null)
				ovest = miaCasella.getLinkOvest().getCasellaOvest();
		}
		catch(EccezioneCardMinMax e){
			e.printStackTrace();
			System.exit(1);
		}
		minDist=nord;
		if (minDist == null || (est != null && minDist != null && distanzaOro(minDist) > distanzaOro(est))){
			minDist = est;
		}
		if (minDist == null || (sud != null && minDist != null && distanzaOro(minDist) > distanzaOro(sud))){
			minDist = sud;
		}
		if (minDist == null || (ovest != null && minDist != null && distanzaOro(minDist) > distanzaOro(ovest))){
			minDist = ovest;
		}
		//
		if (minDist==nord){
			// richiedi al controllore di muovere a nord
			contr.muoviNord(this);
		}
		if (minDist==est){
			// richiedi all'interfaccia di muovere a est
			contr.muoviEst(this);
		}
		if (minDist==sud){
			// richiedi all'interfaccia di muovere a sud
			contr.muoviSud(this);
		}
		if (minDist==ovest){
			// richiedi all'interfaccia di muovere a ovest
			contr.muoviOvest(this);
		}
	}
	
	// Meotodi ausiliari: possono essere chiamati solo da oggetti di questa classe
	
	private int distanzaPozzo(Casella c)
	{// Restituisce la distanza della casella passata in input dal pozzo ad essa pi vicino
		HashSet<Casella> marche=new HashSet<Casella>();
		return(distanzaHelper(c,Pozzo.class,marche));
	}

	private int distanzaOro(Casella c)
	{// Restituisce la distanza della casella passata in input da un'altra contenente un sacchetto d'oro, ad essa pi vicino
		HashSet<Casella> marche=new HashSet<Casella>();
		return(distanzaHelper(c,SacchettoOro.class,marche));
	}
	
	private int distanzaHelper(Casella c,Class<?> classe,HashSet<Casella> marche)
	{
		if (marche.contains(c))
			return(Integer.MAX_VALUE);
		Set<TipoLinkOspita> ospita=c.getLinkOspita();
		Iterator<TipoLinkOspita> iter=ospita.iterator();
		while(iter.hasNext())
		{
			TipoLinkOspita link=iter.next();
			if (link.getElemento().getClass().equals(classe))
				return(0);
		}
		marche.add(c);
		int valMinimo=Integer.MAX_VALUE-1;
		int valCorr;
		if (c.getLinkEst()!=null)
		{
			valCorr=distanzaHelper(c.getLinkEst().getCasellaEst(),classe,(HashSet<Casella>)marche.clone());
			if (valCorr<valMinimo)
				valMinimo=valCorr;
		}
		if (c.getLinkSud()!=null)
		{
			valCorr=distanzaHelper(c.getLinkSud().getCasellaSud(),classe,(HashSet<Casella>)marche.clone());
			if (valCorr<valMinimo)
				valMinimo=valCorr;
		}
		if (c.getLinkNord()!=null)
		{
			valCorr=distanzaHelper(c.getLinkNord().getCasellaNord(),classe,(HashSet<Casella>)marche.clone());
			if (valCorr<valMinimo)
				valMinimo=valCorr;
		}
		if (c.getLinkOvest()!=null)
		{
			valCorr=distanzaHelper(c.getLinkOvest().getCasellaOvest(),classe,(HashSet<Casella>)marche.clone());
			if (valCorr<valMinimo)
				valMinimo=valCorr;
		}		
		return(1+valMinimo);
	}
}
