package goldSeeker;

import java.util.*;

public class Casella 
{
	private final HashSet<TipoLinkOspita> link=new HashSet<TipoLinkOspita>(); 
	private TipoLinkLatitudine nord=null;
	private TipoLinkLatitudine sud=null;
	private TipoLinkLongitudine est=null;
	private TipoLinkLongitudine ovest=null;
	
	private final static int MAX_LINKOSPITA=2;
	
	public void inserisciPerManagerOspita (ManagerOspita k) 
	{
		if (k!=null)
			link.add(k.getLink());
	}
	
	public void eliminaPerManagerOspita (ManagerOspita k)
	{
		if (k!=null)
			link.remove(k.getLink());
	}
	
	public Set<TipoLinkOspita> getLinkOspita()
	{
		return((Set<TipoLinkOspita>)link.clone());
	}

	public void inserisciPerManagerLatitudineNord(ManagerLatitudine k) 
	{
		if (k.getLink()!=null)
			nord = k.getLink();
		else
			nord = null;
	}
	
	public void inserisciPerManagerLatitudineSud(ManagerLatitudine k) 
	{
		if (k.getLink()!=null)
			sud = k.getLink();
		else
			sud = null;
	}

	public TipoLinkLatitudine getLinkNord() {
		return nord;
	}

	public TipoLinkLatitudine getLinkSud() {
		return sud;
	}

	public void eliminaPerManagerLatitudineNord(ManagerLatitudine k) 
	{
		if (k.getLink().equals(nord))
			nord=null;
	}

	public void eliminaPerManagerLatitudineSud(ManagerLatitudine k) 
	{
		if (k.getLink().equals(sud))
			sud=null;
	}

	public void inserisciPerManagerLongitudineEst(ManagerLongitudine k) 
	{
		if (k.getLink()!=null)
			est = k.getLink();
		else
			est = null;
	}
	
	public void inserisciPerManagerLongitudineOvest(ManagerLongitudine k) 
	{
		if (k.getLink()!=null)
			ovest = k.getLink();
		else
			ovest = null;
	}

	public TipoLinkLongitudine getLinkEst() {
		return est;
	}

	public TipoLinkLongitudine getLinkOvest() {
		return ovest;
	}

	public void eliminaPerManagerLongitudineEst(ManagerLongitudine k) 
	{
		if (k.getLink().equals(est))
			est=null;
	}

	public void eliminaPerManagerLongitudineOvest(ManagerLongitudine k) 
	{
		if (k.getLink().equals(ovest))
			ovest=null;
	}		
	
	// Verifica degli invarianti
	public boolean invariante(){
		// Ogni casella deve averne sempre almeno una adiacente
		if (nord == null && ovest == null & sud == null & est == null)
			return false;
		// Nessuna casella pu essere adiacente a se stessa
		if (nord != null && nord.getCasellaNord() == this)
			return false;
		if (sud != null && sud.getCasellaSud() == this)
				return false;
		if (ovest != null && ovest.getCasellaOvest() == this)
			return false;
		if (est != null && est.getCasellaEst() == this)
			return false;
		// Non possono coesistere un pozzo ed un sacchetto d'oro o (almeno) due sacchetti d'oro nella stessa casella
		boolean trovatoOro = false;
		Iterator<TipoLinkOspita> iterOspita = link.iterator();
		while(!trovatoOro && iterOspita.hasNext()){
			if (iterOspita.next().getElemento().getClass() == SacchettoOro.class){
				trovatoOro = true;
			}
		}
		while(iterOspita.hasNext()){
			if (iterOspita.next().getElemento().getClass() == SacchettoOro.class){
				return false;
			}			
		}
		//
		return true;
	}	
}
