package applicazione;

import goldSeeker.*;
import gestioneeventi.*;
import java.io.*;

import java.util.*;

import GUI.MainWindow;
import javax.swing.*;
public class Main
{
	private static final int numCaselle = 14;

	public static void main(String args[]) throws EccezionePrecondizioni, EccezioneInvarianti
	{
		int continuaGioco = JOptionPane.YES_OPTION;
		while(continuaGioco == JOptionPane.YES_OPTION){
			ControlloreGioco i=creaControllore();
			// Prepara l'environment
			Environment env = new Environment();
			Set<Casella> caselleMappa = i.getLinks();
			Iterator<Casella> iterCasella = caselleMappa.iterator();
			while(iterCasella.hasNext()){
					Iterator<TipoLinkOspita> iterOspita = iterCasella.next().getLinkOspita().iterator();
					while(iterOspita.hasNext()){
						Elemento elementoCorrente = iterOspita.next().getElemento();
						if (elementoCorrente instanceof Cercatore){
							Cercatore c = (Cercatore) elementoCorrente;
							env.addListener(c);
							env.aggiungiEvento(new InizioGioco(null,c));
						}
					}
			}
			//
			MainWindow finestra=new MainWindow(i);
			i.setFinestra(finestra);
			env.eseguiEnvironment();
			
			continuaGioco = JOptionPane.showConfirmDialog(null,"La partita  finita, vuoi giocare ancora?","",JOptionPane.YES_NO_OPTION);
		}
		System.exit(0);
		
	}
	
	public static void stampaMappa(ControlloreGioco m)
	{
		// Funzione Ausiliaria che stampa una mappa in formato testuale
		Casella [][] matrice = m.trasformaInMatrice();
		for (int i = matrice.length-1; i >= 0 ; i--)
		{
			for (int j = 0; j < matrice[i].length; j++){
				String carattere = " ";
				if (matrice[i][j]!=null && matrice[i][j].getLinkNord()!= null){
					carattere = "|";
				}
				System.out.print(carattere+" ");
			}
			System.out.println();			
			for (int j = 0; j < matrice[i].length; j++){
				String carattere = " ";
				String estConn=" ";
				if (matrice[i][j]!=null){
					carattere = "x";
					if (matrice[i][j].getLinkEst()!=null){
						estConn = "-";
					}
				}				
				System.out.print(carattere+estConn);
			}
			System.out.println();					
		}
	}
	
	
	
	private static ControlloreGioco creaControllore() throws EccezionePrecondizioni
	{
		ControlloreGioco m=new ControlloreGioco();
		Casella[] caselle = new Casella[numCaselle];
		// Associa tutte le caselle alla mappa m
		for (int i=0;i<numCaselle;i++)
		{
			caselle[i]=new Casella();
			m.inserisciCasella(caselle[i]);
		}
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[1],caselle[0]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[2],caselle[1]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[6],caselle[2]));
		ManagerLatitudine.inserisci(new TipoLinkLatitudine(caselle[3],caselle[2]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[4],caselle[3]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[5],caselle[4]));
		ManagerLatitudine.inserisci(new TipoLinkLatitudine(caselle[5],caselle[7]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[7],caselle[6]));
		ManagerLatitudine.inserisci(new TipoLinkLatitudine(caselle[6],caselle[8]));
		ManagerLatitudine.inserisci(new TipoLinkLatitudine(caselle[8],caselle[9]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[10],caselle[8]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[11],caselle[10]));
		ManagerLatitudine.inserisci(new TipoLinkLatitudine(caselle[12],caselle[11]));
		ManagerLatitudine.inserisci(new TipoLinkLatitudine(caselle[13],caselle[12]));
		ManagerLongitudine.inserisci(new TipoLinkLongitudine(caselle[13],caselle[5]));

		ManagerOspita.inserisci(new TipoLinkOspita(new Pozzo(), caselle[12]));
		ManagerOspita.inserisci(new TipoLinkOspita(new Pozzo(), caselle[0]));
		ManagerOspita.inserisci(new TipoLinkOspita(new Pozzo(), caselle[6]));
		
		ManagerOspita.inserisci(new TipoLinkOspita(new SacchettoOro(15), caselle[7]));
		ManagerOspita.inserisci(new TipoLinkOspita(new SacchettoOro(8), caselle[1]));
		ManagerOspita.inserisci(new TipoLinkOspita(new SacchettoOro(3), caselle[9]));
		
		ManagerOspita.inserisci(new TipoLinkOspita(new CercatoreAutonomo("Topolino", m), caselle[8]));
		//ManagerOspita.inserisci(new TipoLinkOspita(new CercatoreAutonomo("Pluto", m), caselle[11]));
		//ManagerOspita.inserisci(new TipoLinkOspita(new CercatoreAutonomo("Minnie", m), caselle[4]));
		ManagerOspita.inserisci(new TipoLinkOspita(new CercatoreControllato("Pluto",m), caselle[11]));
		return(m);
	}
	private Main(){}
}
