package applicazione;

import goldSeeker.*;

import java.util.*;

import GUI.MainWindow;

public class ControlloreGioco 
{
	private final HashSet<Casella> insieme_link=new HashSet<Casella>();
	private MainWindow finestra;
	
	private void muovi(Cercatore c,Casella a)
	{// Sposta il Cercatore c dalla Casella in cui si trova alla Casella a
		//Completare
	}

	public void abilitaMovimento(CercatoreControllato c)
	{
		finestra.abilitaMovimento(c);
		try {
			//Trascurare questa istruzione, qui e nel seguito
			synchronized(this)
			{
				this.wait();
			}
		} catch (InterruptedException e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public boolean muoviNord(Cercatore c)
	{
		synchronized(this){
			try {
				muovi(c,c.getLinkOspita().getCasella().getLinkNord().getCasellaNord());
				return true;
			} 
			catch (EccezioneCardMinMax e) {
				e.printStackTrace();
				System.exit(1);
				return false;// non  mai eseguita
			}
			catch (NullPointerException e) {
				return false;
			}			
		}
	}

	public boolean muoviEst(Cercatore c)
	{
			try {
				muovi(c,c.getLinkOspita().getCasella().getLinkEst().getCasellaEst());
				return true;
			} 
			catch (EccezioneCardMinMax e) {
				e.printStackTrace();
				return false;
			}
			catch (NullPointerException e) {
				return false;
			}			
	}
	
	public boolean muoviOvest(Cercatore c)
	{
			try {
				muovi(c,c.getLinkOspita().getCasella().getLinkOvest().getCasellaOvest());
				return true;
			} catch (EccezioneCardMinMax e) {
				e.printStackTrace();
				return false;
			}
			catch (NullPointerException e) {
				return false;
			}			
	}	
	
	public boolean muoviSud(Cercatore c)
	{
			try {
				muovi(c,c.getLinkOspita().getCasella().getLinkSud().getCasellaSud());
				return true;
			} catch (EccezioneCardMinMax e) 
			{
				e.printStackTrace();
				return false;
			}
			catch (NullPointerException e) {
				return false;
			}			
	}
	
	public void inserisciCasella(Casella link)
	{
		if (link!=null)
			insieme_link.add(link);
	}
	
	public void eliminaCasella(Casella link)
	{
		if (link!=null)
			insieme_link.remove(link);
	}

	@SuppressWarnings("unchecked")
	public Set<Casella> getLinks() 
	{
		return (Set<Casella>)insieme_link.clone();
	}
	
	//Il seguente metodo serve solo all'interfaccia grafica.
	public Casella[][] trasformaInMatrice()
	{	
		// Record per memorizzare coordinate
		class Pair{
			public Pair(int x,int y){
				this.x=x;
				this.y=y;
			}
			private int x,y;
			public String toString(){// usata solo per debugging
				return "("+x+","+y+")";
			}
		}
		
		// Crea una matrice sovradimensionata per contenere la mappa
		int dimensioneMatrice=insieme_link.size()*2;
		Casella[][] mappaMatrice=new Casella[dimensioneMatrice][dimensioneMatrice];
		// Inizializza tutti gli elementi della mappa a null
		for (int i=0; i<dimensioneMatrice; i++){
			for(int j=0; j<dimensioneMatrice; j++){
				mappaMatrice[i][j]=null;
			}
		}
				
		// Caselle della mappa visitate
		HashSet<Casella> caselleVisitate = new HashSet<Casella>();
		
		// Componenti (espresse in coordinate) di mappaMatrice da espandere
		//Ogni elemento dell'insiem  una coppia di coordinate (riga,colonna) della matrice
		Set<Pair> caselleDaEspandere = new HashSet<Pair>();
		 

		//Seleziona un elemento della mappa da cui cominciare (la mappa  connessa per ipotesi)
		Iterator<Casella> iterLinkInclude = insieme_link.iterator();
		if (!iterLinkInclude.hasNext()){
			return null;
		}
		Casella casellaCorrente = iterLinkInclude.next();
		
		//Inserisce l'elemento in posizione centrale di mappaMatrice
		// La matrice  sovradimensionata per impedire di uscire dai limiti)
		Pair curPair = new Pair(dimensioneMatrice/2,dimensioneMatrice/2);		
		mappaMatrice[curPair.x][curPair.y]=casellaCorrente;
		
		//Intervallo di righe e colonne effettivamente occupato
		int minRighe=curPair.x, maxRighe = curPair.x, minColonne = curPair.y, maxColonne = curPair.y;
		
		// Inizializza le componenti da espandere
		caselleDaEspandere.add(curPair);

		while(!caselleDaEspandere.isEmpty()){// Visita la mappa

			// Seleziona una componente per l'espansione (e la rimuove da quelle da espandere)
			curPair = caselleDaEspandere.iterator().next();
			caselleDaEspandere.remove(curPair);
			casellaCorrente = mappaMatrice[curPair.x][curPair.y];
			// Aggiorna la matrice e le componenti da espandere
			Pair newPair=null;
			// Nord
			if (casellaCorrente.getLinkNord()!= null && !caselleVisitate.contains(casellaCorrente.getLinkNord().getCasellaNord())){
					newPair = new Pair(curPair.x+1,curPair.y);
					mappaMatrice[newPair.x][newPair.y]=casellaCorrente.getLinkNord().getCasellaNord();
					caselleDaEspandere.add(newPair);
					if (newPair.x>maxRighe){
						maxRighe = newPair.x;
					}
			}
			//Est
			if (casellaCorrente.getLinkEst()!= null && !caselleVisitate.contains(casellaCorrente.getLinkEst().getCasellaEst())){
				newPair = new Pair(curPair.x,curPair.y+1);
				mappaMatrice[newPair.x][newPair.y]=casellaCorrente.getLinkEst().getCasellaEst();
				caselleDaEspandere.add(newPair);
				if (newPair.y>maxColonne){
					maxColonne = newPair.y;
				}
			}
			//Sud
			if (casellaCorrente.getLinkSud()!= null && !caselleVisitate.contains(casellaCorrente.getLinkSud().getCasellaSud())){
				newPair = new Pair(curPair.x-1,curPair.y);
				mappaMatrice[newPair.x][newPair.y]=casellaCorrente.getLinkSud().getCasellaSud();
				caselleDaEspandere.add(newPair);
				if (newPair.x<minRighe){
					minRighe = newPair.x;
				}
			}
			//Ovest
			if (casellaCorrente.getLinkOvest()!= null && !caselleVisitate.contains(casellaCorrente.getLinkOvest().getCasellaOvest())){
				newPair = new Pair(curPair.x,curPair.y-1);
				mappaMatrice[newPair.x][newPair.y]=casellaCorrente.getLinkOvest().getCasellaOvest();
				caselleDaEspandere.add(newPair);
				if (newPair.y<minColonne){
					minColonne = newPair.y;
				}
			}
			// Aggiunge la casella espansa a quelle visitate
			caselleVisitate.add(casellaCorrente);
		}// Fine while
		
		// Costruisce una matrice di dimensione minima tale da contenere la mappa
		Casella[][] risultato = new Casella[maxRighe-minRighe+1][maxColonne-minColonne+1];
		
		//Copia la porzione effettiva di mappaMatrice in risultato:
		for (int i=minRighe;i<=maxRighe;i++){
			for (int j=minColonne;j<=maxColonne;j++){
				risultato[i-minRighe][j-minColonne]=mappaMatrice[i][j];
			}
		}
		// Restituisce risultato
		return risultato;
	}	
	
	public void setFinestra(MainWindow finestra) {
		this.finestra = finestra;
	}

}
