package GUI;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Iterator;

import applicazione.ControlloreGioco;

import goldSeeker.*;
import it.uniroma1.dis.PS.DrawPanel;
import it.uniroma1.dis.PS.Ellipse;
import it.uniroma1.dis.PS.Line;
import it.uniroma1.dis.PS.Polygon;
import it.uniroma1.dis.PS.Text;

public class MappaPanel extends DrawPanel 
{
	ControlloreGioco mappa;
	private static final int ALTEZZA_CASELLE=40;
	private static final int LARGHEZZA_CASELLE=40;
	
	public MappaPanel(ControlloreGioco unaMappa)
	{
		mappa=unaMappa;
		aggiorna();
	}
	
	@Override
	public Dimension getPreferredSize()
	{
		Casella[][] caselle=mappa.trasformaInMatrice();
		int height=caselle.length*ALTEZZA_CASELLE;
		int width=0;
		if (caselle.length>0)
			width=caselle[0].length*LARGHEZZA_CASELLE;
		Dimension dimensione=new Dimension(width,height);
		return(dimensione);
	}
	
	public void aggiorna() 
	{
		this.reset();
		Casella[][] caselle=mappa.trasformaInMatrice();
		Point punti[];
		Polygon poligono;
		for (int i=0;i<caselle.length;i++)
			for(int j=0;j<caselle[i].length;j++)
			{
				int k=caselle.length-1-i;
				punti = new Point[4];
				punti[0] = new Point(j * LARGHEZZA_CASELLE, k * ALTEZZA_CASELLE);
				punti[1] = new Point((j + 1) * LARGHEZZA_CASELLE, k * ALTEZZA_CASELLE);
				punti[2] = new Point((j + 1) * LARGHEZZA_CASELLE, (k + 1) * ALTEZZA_CASELLE);
				punti[3] = new Point(j * LARGHEZZA_CASELLE, (k + 1) * ALTEZZA_CASELLE);
				poligono = new Polygon(punti, false);
				if (caselle[i][j] == null)
					poligono.setFillColor(Color.BLACK);
				this.addFigureBatch(poligono);
				if (caselle[i][j] != null) 
				{
					if (caselle[i][j].getLinkEst() == null)
					{
						Line l=new Line(punti[1], punti[2]);
						l.setLineSize(3);
						addFigure(l);
					}
					if (caselle[i][j].getLinkNord() == null)
					{
						Line l=new Line(punti[0], punti[1]);
						l.setLineSize(3);
						addFigure(l);		
					}
					Iterator<TipoLinkOspita> list=caselle[i][j].getLinkOspita().iterator();
					while (list.hasNext()) {
						Elemento elem = list.next().getElemento();
						Point centro = new Point((int)((j+0.5) * LARGHEZZA_CASELLE), (int)((k+0.5) * ALTEZZA_CASELLE));
						Ellipse e=new Ellipse(centro,LARGHEZZA_CASELLE/4,ALTEZZA_CASELLE/4);
						e.setLineSize(3);
						if (elem instanceof Pozzo)
						{
							e.setFillColor(Color.CYAN);
							this.addFigureBatch(e);
						}
						if (elem instanceof SacchettoOro)
						{
							e.setFillColor(Color.YELLOW);
							this.addFigureBatch(e);
						}
						if (elem instanceof CercatoreAutonomo)
						{
							punti = new Point[4];
							punti[0] = new Point((int)((j+0.25) * LARGHEZZA_CASELLE), (int)((k+0.25) * ALTEZZA_CASELLE));
							punti[1] = new Point((int)((j + 0.75) * LARGHEZZA_CASELLE), (int)((k+0.25) * ALTEZZA_CASELLE));
							punti[2] = new Point((int)((j + 0.75) * LARGHEZZA_CASELLE), (int)((k + 0.75) * ALTEZZA_CASELLE));
							punti[3] = new Point((int)((j + 0.25) * LARGHEZZA_CASELLE), (int)((k + 0.75) * ALTEZZA_CASELLE));
							poligono = new Polygon(punti, false);
							poligono.setLineSize(3);
							poligono.setFillColor(Color.ORANGE);									
							Point testoPunt=new Point((int)((j + 0.28) * LARGHEZZA_CASELLE), (int)((k + 0.6) * ALTEZZA_CASELLE));
							this.addFigureBatch(poligono);
							this.addFigureBatch(new Text("CA",testoPunt));
						}
						if (elem instanceof CercatoreControllato)
						{
							punti = new Point[4];
							punti[0] = new Point((int)((j+0.25) * LARGHEZZA_CASELLE), (int)((k+0.25) * ALTEZZA_CASELLE));
							punti[1] = new Point((int)((j + 0.75) * LARGHEZZA_CASELLE), (int)((k+0.25) * ALTEZZA_CASELLE));
							punti[2] = new Point((int)((j + 0.75) * LARGHEZZA_CASELLE), (int)((k + 0.75) * ALTEZZA_CASELLE));
							punti[3] = new Point((int)((j + 0.25) * LARGHEZZA_CASELLE), (int)((k + 0.75) * ALTEZZA_CASELLE));
							poligono = new Polygon(punti, false);
							poligono.setLineSize(3);
							poligono.setFillColor(Color.RED);
							Point testoPunt=new Point((int)((j + 0.28) * LARGHEZZA_CASELLE), (int)((k + 0.6) * ALTEZZA_CASELLE));
							this.addFigureBatch(poligono);
							this.addFigureBatch(new Text("CC",testoPunt));
						}
					}
				}
				punti = new Point[4];
				punti[0]=new Point(0,0);
				punti[1]=new Point(LARGHEZZA_CASELLE*caselle[0].length,0);
				punti[2]=new Point(LARGHEZZA_CASELLE*caselle[0].length,ALTEZZA_CASELLE*caselle.length);					
				punti[3]=new Point(0,ALTEZZA_CASELLE*caselle.length);	
				Polygon p=new Polygon(punti, true);
				p.setLineSize(3);
				this.addFigureBatch(p);
			}
		this.commit();		
	}
}
