package GUI;

import java.awt.event.*;

import applicazione.ControlloreGioco;

public class GuiListener implements ActionListener
{
	public final static String NORD="N";
	public final static String SUD="S";
	public final static String EST="E";
	public final static String OVEST="O";
	private MainWindow frame;
	
	public GuiListener(MainWindow frame)
	{
		this.frame=frame;
	}
	
	public void actionPerformed(ActionEvent e)
	{
		String com=e.getActionCommand();
		ControlloreGioco inter=frame.getInterfacciaGrafica();
		boolean mossaEseguita = false;
			if (com==NORD)
				mossaEseguita = inter.muoviNord(frame.getCercatore());
			else if (com==SUD)
				mossaEseguita = inter.muoviSud(frame.getCercatore());
			else if (com==EST)
				mossaEseguita = inter.muoviEst(frame.getCercatore());
			else if (com==OVEST)
				mossaEseguita = inter.muoviOvest(frame.getCercatore());	
		if (mossaEseguita){
			frame.disabilitaMovimento();
			synchronized(inter)
			{
				inter.notify();
			}
		}
	}
}
