package gui;

import giunte.EccezionePrecondizioni;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;



public class AggiungiPersonaPartitoListener implements ActionListener 
{
	private AggiungiPersonaPartitoFrame frame;
	public final static String ISCRIVIPARTITO="I";
	public final static String INFOPERSONA="P";
	
	public AggiungiPersonaPartitoListener(AggiungiPersonaPartitoFrame unFrame)
	{
		this.frame=unFrame;
	}
	
	
	public void actionPerformed(ActionEvent ae) 
	{
		String com=ae.getActionCommand();
		if (com==ISCRIVIPARTITO)
			iscriviPersona();
		else if (com==INFOPERSONA)
			infoPersona();
	}	
	
		
	private void infoPersona()
	{
		InfoAggiungiPersonaPartito info=frame.getInformazioni();
		new InfoPersonaFrame(info.getPersona());
	}
		
	private void iscriviPersona()
	{
		InfoAggiungiPersonaPartito info=frame.getInformazioni();
		try {
			frame.getModello().addPersonaPartito(info.getPersona(), 
					info.getPartito(), 
					Integer.parseInt(info.getAnnoIscrizione()));
			Utility.messaggioAvviso(frame, "La persona  stata iscritta al partito");
			frame.reset();
		} catch (NumberFormatException e) {
			Utility.messaggioErrore(frame, "Anno iscrizione errato");
		} catch (EccezionePrecondizioni e) {
			Utility.messaggioErrore(frame, e.getMessage());
		}
		
	}

}

