package gui;

import giunte.EccezionePrecondizioni;
import giunte.Persona;
import giunte.Regione;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;



public class AggiungiPersonaGiuntaListener implements ActionListener 
{
	private AggiungiPersonaGiuntaFrame frame;
	public final static String ELEGGIGIUNTA="E";
	public final static String INFOPERSONA="P";
	public static final String INFOREGIONE = "R";
	
	public AggiungiPersonaGiuntaListener(AggiungiPersonaGiuntaFrame unFrame)
	{
		this.frame=unFrame;
	}
	
	
	public void actionPerformed(ActionEvent ae) 
	{
		String com=ae.getActionCommand();
		if (com==ELEGGIGIUNTA)
			eleggiGiunta();
		else if (com==INFOPERSONA)
			infoPersona();
		else if (com==INFOREGIONE)
			infoRegione();
	}	
	
	private void infoRegione()
	{
		//DA COMPLETARE A CURA DEGLI STUDENTI		
	}
	
	private void infoPersona()
	{
		InfoAggiungiPersonaGiunta info=frame.getInformazioni();
		Persona p=info.getPersona();
		if (p!=null)
			new InfoPersonaFrame(p);
	}
		
	private void eleggiGiunta()
	{
		InfoAggiungiPersonaGiunta info=frame.getInformazioni();
		
		try {
			frame.getModello().addPersonaGiunta(info.getPersona(), 
					info.getRegione(), 
					Integer.parseInt(info.getAnnoElezione()));
			Utility.messaggioAvviso(frame, "La persona  stata agginta alla giunta");
			frame.reset();
		} 
		catch(NullPointerException e)
		{
			Utility.messaggioAvviso(frame, "Nessuna persona o giunta in archivio");
		}
		catch (NumberFormatException e) 
		{
			Utility.messaggioErrore(frame, "Anno elezione errato");
		} catch (EccezionePrecondizioni e) {
			Utility.messaggioErrore(frame, e.getMessage());
		}
		
	}

}

