package giunte;

public class TipoLinkIscritto 
{
	private final Partito ilPartito;
	private final Persona laPersona;
	private final int annoIscrizione;
	public TipoLinkIscritto(Partito x, Persona y, int a)
	throws EccezionePrecondizioni {
		if (x == null || y == null|| a <= 0) // CONTROLLO PRECONDIZIONI
			throw new EccezionePrecondizioni
			("Gli oggetti devono essere inizializzati\n" +
			"e lanno di iscrizione deve essere positivo");
		ilPartito = x; laPersona = y; annoIscrizione = a;
	}
	public Partito getPartito() { return ilPartito; }
	public Persona getPersona() { return laPersona; }
	public int getAnnoIscrizione() { return annoIscrizione; }
	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkIscritto b = (TipoLinkIscritto)o;
			return b.laPersona == laPersona && b.ilPartito == ilPartito;
		}
		else return false;
	}
	
	public int hashCode() {
		return laPersona.hashCode() + ilPartito.hashCode();
	}
}