package gui;

import giunte.EccezionePrecondizioni;
import giunte.Regione;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;



public class PrincipaleListener implements ActionListener 
{
	public static final String AGGPERSONA="A";
	public static final String AGGPERSONAPARTITO="AP";
	public static final String AGGPARTITO = "P";
	public static final String AGGREGIONE = "R";
	public static final String AGGPERSONAREGIONE = "AR";
	private PrincipaleFrame frame;
	
	public PrincipaleListener(PrincipaleFrame unFrame)
	{
		frame=unFrame;
	}
	
	public void actionPerformed(ActionEvent ae) 
	{
		String command = ae.getActionCommand();
		Modello m=frame.getModello();
		if (command == AGGPERSONA)
			new AggiungiPersonaFrame(m);
		else if (command == AGGPERSONAPARTITO)
			new AggiungiPersonaPartitoFrame(m);
		else if (command == AGGPARTITO)
			new AggiungiPartitoFrame(m);
		else if (command == AGGREGIONE)
			aggRegione(m);
		else if (command == AGGPERSONAREGIONE)
			new AggiungiPersonaGiuntaFrame(m);
	}
	
	private void aggRegione(Modello m)
	{
		String nomeRegione=(String)JOptionPane.
			showInputDialog(frame, "Inserire il nome della regione:", "Aggiungi Regione", JOptionPane.QUESTION_MESSAGE);
		try {
			//Se non  stato cliccato su annulla
			if(nomeRegione!=null)
				m.addRegione(new Regione(nomeRegione));
		} catch (EccezionePrecondizioni e) {
			Utility.messaggioErrore(frame, e.getMessage());
		}
	}
}
