package gui;

import giunte.*;

import java.awt.BorderLayout;
import java.util.*;

import javax.swing.*;



public class InfoGiuntaFrame extends JFrame
{
	private JTable tabella;
	private final static Object[] intestazioni=
		{"Persona","Anno Elezione"};
	private final JLabel infoLabel;
	
	private Object[][] dammiMatrice(Regione r)
	{
		Set<TipoLinkGiunta> insieme=r.getGiunta();
		Object[][] ritorno=new Object[insieme.size()][2];
		Iterator<TipoLinkGiunta> iter=insieme.iterator();
		int i=0;
		while(iter.hasNext())
		{
			TipoLinkGiunta valore=iter.next();
			ritorno[i][0]=valore.getPersona();
			ritorno[i++][1]=valore.getAnnoElezione();
		}
		return(ritorno);
	}
	
	public InfoGiuntaFrame(Regione r)
	{
		Object[][] dati=dammiMatrice(r);
		tabella=new JTable(dati,intestazioni);
		this.getContentPane().add(new JScrollPane(tabella),BorderLayout.CENTER);
		Utility.centraFrame(this);
		String text="";
		if (r.getGiunta().size()>0)
		{
			Partito p=Operazioni.monocolore(r);
			if (p!=null)
				text="Giunta composta da membri afferenti allo stesso partito "+p;
			else
				text="Giunta multi-partitica";
		}
		infoLabel=new JLabel(text);
		this.getContentPane().add(infoLabel,BorderLayout.SOUTH);
		setSize(300,300);
		setVisible(true);
	}
	
	
	
}
