package gui;

import giunte.*;

import java.awt.BorderLayout;
import java.awt.FlowLayout;

import javax.swing.*;



class InfoAggiungiPersonaPartito
{
	private Persona persona;
	private Partito partito;
	private String annoIscrizione;
	
	public InfoAggiungiPersonaPartito(Persona unaPersona,Partito unPartito,String unAnnoIscrizione)
	{
		persona=unaPersona;
		partito=unPartito;
		annoIscrizione=unAnnoIscrizione;
	}
	
	public Persona getPersona() {
		return persona;
	}
	public Partito getPartito() {
		return partito;
	}
	public String getAnnoIscrizione() {
		return annoIscrizione;
	}
}

public class AggiungiPersonaPartitoFrame extends JFrame 
{
	private JComboBox personaBox;
	private JLabel personaLbl=new JLabel("Persona:");
	private JPanel personaPnl=new JPanel();
	private JButton personaInfoBtn=new JButton("Info");
	private JComboBox partitoBox;
	private JLabel partitoLbl=new JLabel("Partito:");
	private JPanel partitoPnl=new JPanel();
	private JLabel iscrizioneLbl=new JLabel("Anno iscrizione:");
	private JTextField iscrizioneTxt=new JTextField(4);
	private JPanel iscrizionePnl=new JPanel();
	private JPanel centroPnl=new JPanel();
	private JPanel sudPnl=new JPanel();
	private JButton okBtn=new JButton("OK");
	private AggiungiPersonaPartitoListener listener=
		new AggiungiPersonaPartitoListener(this);
	private Modello modello;
	
	public Modello getModello()
	{
		return(modello);
	}
	
	public AggiungiPersonaPartitoFrame(Modello m)
	{
		super("Iscrizione persone a partiti");
		personaBox=new JComboBox(m.getPersone().toArray());		
		partitoBox=new JComboBox(m.getPartiti().toArray());
		personaPnl.add(personaLbl);
		personaPnl.add(personaBox);
		personaPnl.add(personaInfoBtn);
		personaInfoBtn.addActionListener(listener);
		personaInfoBtn.setActionCommand(AggiungiPersonaPartitoListener.INFOPERSONA);
		partitoPnl.add(partitoLbl);
		partitoPnl.add(partitoBox);
		iscrizionePnl.add(iscrizioneLbl);
		iscrizionePnl.add(iscrizioneTxt);		
		centroPnl.setLayout(new FlowLayout(FlowLayout.LEFT));
		centroPnl.add(personaPnl);
		centroPnl.add(partitoPnl);
		centroPnl.add(iscrizionePnl);
		sudPnl.add(okBtn);
		okBtn.addActionListener(listener);
		okBtn.setActionCommand(AggiungiPersonaPartitoListener.ISCRIVIPARTITO);
		this.getContentPane().add(centroPnl,BorderLayout.CENTER);
		this.getContentPane().add(sudPnl,BorderLayout.SOUTH);		
		this.setSize(350,220);
		this.setVisible(true);
		this.setResizable(false);
		modello=m;
	}
	
	public InfoAggiungiPersonaPartito getInformazioni()
	{
		InfoAggiungiPersonaPartito info;
		info=new InfoAggiungiPersonaPartito(
				(Persona)personaBox.getSelectedItem(), 
				(Partito)partitoBox.getSelectedItem(), 
				iscrizioneTxt.getText());
		return(info);
	}
	
	public void reset()
	{
		personaBox.setSelectedIndex(0);
		partitoBox.setSelectedIndex(0);
		iscrizioneTxt.setText("");
	}
}
