import java.util.*;

public class Ludoteca{
    String nome;
    Map<Gioco,Persona> prestiti;
    /*
     * Usiamo il Java Collection Framework con generic types
     * Memorizziamo in una mappa <Gioco,persona> le informazioni sui prestiti.
     * Assumiamo che un gioco sia prestato ad una sola persona.
     * Se il gioco non  stato prestato allora  disponibile.
     */

    // Costruttore
    public Ludoteca(String nome) {
      this.nome = nome;
      prestiti = new HashMap<Gioco,Persona>();  //uso una classe concreta HashMap che implementa Map
    }
    
    // restutisce il nome della ludoteca
    public String nome() {
      return nome;
    }

    public boolean presente(Gioco g) {
        return prestiti.containsKey(g);
      }

    public Persona chiHaIlGioco(Gioco g) {
        return prestiti.get(g);
      }

      public int numeroGiochi() {
        return prestiti.size();
      }

      public int numeroGiochiPrestati() {
        int cont = 0;
        Set<Map.Entry<Gioco,Persona>> pset=prestiti.entrySet();// Accediamo al campo dati di Map come se fosse un Set
        Iterator<Map.Entry<Gioco,Persona>> it = pset.iterator();// Otteniamo l'iteratore
        while(it.hasNext()) {
          Map.Entry<Gioco,Persona> e = (Map.Entry<Gioco,Persona>)it.next();// Estraiamo la persona a cui il gioco  stato prestato...
          if (e.getValue() != null) cont++;//...se la persona esiste (non  null) incrementiamo il contatore
        }
        return cont;
      }

      public void aggiungiGioco(Gioco g) {
        prestiti.put(g,null);
      }

      public void eliminaGioco(Gioco g) {
        prestiti.remove(g);
      }

      public void prestaGioco(Gioco g, Persona p) {
        if (!prestiti.containsKey(g))
          throw new RuntimeException(
            "Errore, prestaGioco: il gioco non e' presente");
        else if (prestiti.get(g) != null)
          throw new RuntimeException(
            "Errore, prestaGioco: il gioco e' gia' in prestito");
        else prestiti.put(g,p);
      }

      public void restituisciGioco(Gioco g) {
        if (!prestiti.containsKey(g))
          throw new RuntimeException(
            "Errore, restituisciGioco: il gioco non e' presente");
        else if (prestiti.get(g) == null)
              throw new RuntimeException(
                "Errore, restituisciGioco: il gioco non e' in prestito");
        else prestiti.put(g,null);
      }

      public Gioco[] tuttiIGiochi() {
        Gioco[] ris = new Gioco[numeroGiochi()];
        Object[] ao = prestiti.keySet().toArray();
        for(int i = 0; i < ao.length; i++)
          ris[i] = (Gioco)ao[i];
        return ris;
      }

    }
