package processo;

import java.util.Iterator;
import java.util.List;
import _framework.Executor;

import gui.*;

public class GestioneArea implements Runnable 
{
	private RecordArea record;
	private boolean eseguito=false;
	private List<String> indirizzi;

	public GestioneArea(RecordArea ra) {
		this.record=ra;
	}

	public synchronized void run() 
	{
		if (eseguito)
			return;
		eseguito=true;
		indirizzi=AttivitaIO.inserisciEdifici(record.getNome());
		RegistraInfoEdifici regInfo=new RegistraInfoEdifici(indirizzi,record);
		Executor.perform(regInfo);
		Iterator<String> iter=indirizzi.iterator();
		while(iter.hasNext())
		{
			//Il successivo indirizzo da considerare per un edificio
			String indirizzo=iter.next();
			boolean agibile=AttivitaIO.leggiAgibilita(indirizzo);
			Executor.perform(new AggiornaAgibilita(indirizzo,agibile));
			List<RecordPersona> recQuest=AttivitaIO.leggiQuestionario(indirizzo);
			Executor.perform(new AggiornaInfoEdifici(indirizzo,recQuest));
		}
		AttivitaIO.mostraInfoSalienti(record);
	}

}
