package gui;

import java.awt.BorderLayout;
import java.awt.event.*;
import java.util.*;

import javax.swing.*;

import emergenza.Modello;
import emergenza.Ospedale;

class AggEdificiListener implements ActionListener
{
	private InfoEdificiFrame frame;
	
	public AggEdificiListener(InfoEdificiFrame frame)
	{
		this.frame=frame;
	}
	
	public void actionPerformed(ActionEvent e)
	{
		String indirizzo=JOptionPane.showInputDialog(frame,"Indirizzo edificio:");
		if (indirizzo==null)
			return;
		frame.aggiungiNuovoIndirizzo(indirizzo);
		JOptionPane.showMessageDialog(frame, "Indirizzo aggiunto");
		frame.repaint();
	}
}

class AggOspedaleListener implements ActionListener
{
	private InfoEdificiFrame frame;
	
	public AggOspedaleListener(InfoEdificiFrame frame)
	{
		this.frame=frame;
	}
	
	public void actionPerformed(ActionEvent e)
	{
		Ospedale[] ospedali=Modello.getListaOspedali(false).toArray(new Ospedale[0]);
		Ospedale o=(Ospedale)JOptionPane.showInputDialog(frame,"Quale ospedale:",frame.getTitle(),
				JOptionPane.QUESTION_MESSAGE, null,ospedali,ospedali[0]);
		if (o==null)
			return;
		frame.aggiungiNuovoIndirizzo(o.getIndirizzo());
		JOptionPane.showMessageDialog(frame, "Ospedale aggiunto");
	}
}

class OKEdificiListener implements ActionListener
{
	private InfoEdificiFrame frame;
	
	public OKEdificiListener(InfoEdificiFrame frame)
	{
		this.frame=frame;
	}	
	
	public void actionPerformed(ActionEvent e)
	{
		frame.dispose();
		synchronized(frame)
		{
			frame.notify();
		}
	}
}
	
public class InfoEdificiFrame extends JFrame
{
	private static final long serialVersionUID = 1L;
	private Vector<String> recAree=new Vector<String>();
	private JList areeLst=new JList(recAree);
	private JButton aggAreaBtn=new JButton("Aggiungi nuovo edificio");
	private JButton aggOspedaleBtn=new JButton("Aggiungi ospedale esistente");
	private JButton okBtn=new JButton("OK");
	private JLabel areeLbl=new JLabel("Edifici interessati:");
	private JPanel centroPnl=new JPanel(new BorderLayout());
	private JPanel sudPnl=new JPanel();
	
	void aggiungiNuovoIndirizzo(String indirizzo)
	{
		recAree.add(indirizzo);
		areeLst.updateUI();		
	}
	
	public List<String> getRecordList()
	{
		return(recAree);
	}
	
	public InfoEdificiFrame(String nomeArea)
	{
		super("Inserimento edificio per l'area "+nomeArea);
		centroPnl.add(areeLbl, BorderLayout.NORTH);
		centroPnl.add(new JScrollPane(areeLst),BorderLayout.CENTER);
		sudPnl.add(aggAreaBtn);
		okBtn.addActionListener(new OKEdificiListener(this));
		aggAreaBtn.addActionListener(new AggEdificiListener(this));
		aggOspedaleBtn.addActionListener(new AggOspedaleListener(this));
		sudPnl.add(okBtn);
		sudPnl.add(aggAreaBtn);
		sudPnl.add(aggOspedaleBtn);
		this.getContentPane().add(centroPnl,BorderLayout.CENTER);
		this.getContentPane().add(sudPnl,BorderLayout.SOUTH);
		setSize(550,400);
		setVisible(true);
	}
}
