package gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.*;
import java.util.*;

import javax.swing.*;

class AggAreaListener implements ActionListener
{
	private InfoAreaFrame frame;
	
	public AggAreaListener(InfoAreaFrame frame)
	{
		this.frame=frame;
	}
	
	public void actionPerformed(ActionEvent e)
	{
		String nome=JOptionPane.showInputDialog(frame,"Nome dell'area:");
		if (nome==null)
			return;
		float estFloat=0;
		try 
		{		
			String estensione=JOptionPane.showInputDialog(frame,"Estensione dell'area:");
			estFloat = Float.parseFloat(estensione);
		} 
		catch (NumberFormatException e2) 
		{
			return;
		}
		RecordArea record=new RecordArea(nome,estFloat);
		frame.aggiungiNuovaArea(record);
		JOptionPane.showMessageDialog(frame, "Area aggiunta");
	}
}

class OKListener implements ActionListener
{
	private InfoAreaFrame frame;
	
	public OKListener(InfoAreaFrame frame)
	{
		this.frame=frame;
	}	
	
	public void actionPerformed(ActionEvent e)
	{
		frame.dispose();
		synchronized(frame)
		{
			frame.notify();
		}
	}
}
	
public class InfoAreaFrame extends JFrame
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Vector<RecordArea> recAree=new Vector<RecordArea>();
	private JList areeLst=new JList(recAree);
	private JButton aggAreaBtn=new JButton("Aggiungi nuova area");
	private JButton okBtn=new JButton("OK");
	private JLabel areeLbl=new JLabel("Aree colpite:");
	private JPanel centroPnl=new JPanel(new BorderLayout());
	private JPanel sudPnl=new JPanel(new FlowLayout());
	
	void aggiungiNuovaArea(RecordArea ra)
	{
		recAree.add(ra);
		areeLst.updateUI();
	}
	
	public List<RecordArea> getRecordList()
	{
		return(recAree);
	}
	
	public InfoAreaFrame()
	{
		super("Inserimento aree");
		centroPnl.add(areeLbl, BorderLayout.NORTH);
		centroPnl.add(new JScrollPane(areeLst),BorderLayout.CENTER);
		sudPnl.add(aggAreaBtn);
		okBtn.addActionListener(new OKListener(this));
		aggAreaBtn.addActionListener(new AggAreaListener(this));
		sudPnl.add(okBtn);
		this.getContentPane().add(centroPnl,BorderLayout.CENTER);
		this.getContentPane().add(sudPnl,BorderLayout.SOUTH);
		setSize(300,300);
		setVisible(true);
	}
	
}
