package emergenza;

public abstract class Persona 
{
	private int eta=0;
	private String nominativo=null;
	private TipoLinkCollocazione link=null;
	
	public Persona(int eta, String nominativo) throws EccezionePrecondizioni
	{
		if (eta<=0)
			throw(new EccezionePrecondizioni("L'et deve essere un valore positivo"));
		if (nominativo==null)
			throw(new EccezionePrecondizioni("Non ammessi valori nulli"));
		this.eta=eta;
		this.nominativo=nominativo;
	}

	public int getEta() {
		return eta;
	}

	public String getNominativo() {
		return nominativo;
	}

	public void inserisciLinkPerManagerCollocazione(ManagerCollocazione k) 
	{
		if (k!=null)
		{
			link=k.getLink();
		}		
	}
	
	public TipoLinkCollocazione getLink() throws EccezioneCardMinMax
	{
		if (link==null)
			throw(new EccezioneCardMinMax("Una persona deve essere collocata in un edificio"));
		else
			return link;
	}
}
