package emergenza;

import java.util.*;

public class Edificio 
{
	private boolean agibile=false;
	private final String indirizzo;
	private TipoLinkContiene link=null;
	private HashSet<TipoLinkCollocazione> insiemeLink=new HashSet<TipoLinkCollocazione>();
	
	public Edificio(String indirizzo)
	{
		this.indirizzo=indirizzo;
	}

	public boolean isAgibile() {
		return agibile;
	}

	public void setAgibile(boolean agibile) {
		this.agibile = agibile;
	}

	public String getIndirizzo() {
		return indirizzo;
	}
	
	public void inserisciLinkComprende(TipoLinkCollocazione t) {
		if (t != null && t.getEdificio() == this)
			ManagerCollocazione.inserisci(t);
	}

	public void inserisciLinkPerManagerCollocazione(ManagerCollocazione k) 
	{
		if (k!=null)
		{
			insiemeLink.add(k.getLink());
		}
	}	
	
	public void inserisciLinkComprende(TipoLinkContiene t) {
		if (t != null && t.getEdificio() == this)
			ManagerContiene.inserisci(t);
	}

	public void inserisciLinkPerManagerContiene(ManagerContiene k) 
	{
		if (k!=null)
		{
			link=k.getLink();
		}
	}

	public int numeroPersone()
	{
		return insiemeLink.size();
	}
	
	@SuppressWarnings("unchecked")
	public Set<TipoLinkCollocazione> getLinkCollocazione() throws EccezioneCardMinMax
	{
		if (insiemeLink.size()<1)
			throw(new EccezioneCardMinMax("Violata la cardinalit minima!"));
		else
			return (Set<TipoLinkCollocazione>) insiemeLink.clone();		
	}
	
	public TipoLinkContiene getLinkContiene() throws EccezioneCardMinMax 
	{
		return link;
	}
	
	public int numeroPersoneFerite()
	{
		Iterator<TipoLinkCollocazione> iter=insiemeLink.iterator();
		int numPersFerite=0;
		while(iter.hasNext())
		{
			Persona p=iter.next().getPersona();
			if (p.getClass()==PersonaViva.class)
			{
				PersonaViva pv=(PersonaViva) p;
				if (pv.getTipoLinkRecovero()!=null)
					numPersFerite++;
			}
		}
		return numPersFerite;		
	}
	
	public int numeroPersoneVive()
	{
		Iterator<TipoLinkCollocazione> iter=insiemeLink.iterator();
		int numPersVive=0;
		while(iter.hasNext())
		{
			if (iter.next().getPersona().getClass() == PersonaViva.class)
				numPersVive++;
		}
		return numPersVive;
	}	
	
	public int numeroPersoneMorte()
	{
		Iterator<TipoLinkCollocazione> iter=insiemeLink.iterator();
		int numPersMorte=0;
		while(iter.hasNext())
		{
			if (iter.next().getPersona().getClass() == PersonaMorta.class)
				numPersMorte++;
		}
		return numPersMorte;
	}
	
}
