package processo;

import emergenza.*;
import gui.RecordArea;
import java.util.Iterator;
import java.util.List;

import javax.swing.JOptionPane;

import _framework.Executor;
import _framework.Task;

public class RegistraInfoEdifici implements Task 
{
	private List<String> recordSet;
	private String nomeArea;
	private boolean eseguita=false;
	
	public RegistraInfoEdifici(List<String> recordSet, RecordArea record) 
	{
		this.recordSet=recordSet;
		nomeArea=record.getNome();
		
	}

	public void esegui(Executor e) 
	{
		if(eseguita)
			return;
		eseguita=true;
		try
		{
			Area area=Modello.getAreaByNome(nomeArea);
			Iterator<String> iter=recordSet.iterator();
			while(iter.hasNext())
			{
				String indirizzo=iter.next();
				Edificio edif=Modello.getEdificioByIndirizzo(indirizzo);
				if (edif!=null)
				{
					if (!(edif instanceof Ospedale))
					{
						JOptionPane.showMessageDialog(null,"Tentativo di aggiungere due volte un edificio all'indirizzo "+indirizzo);
						return;
					}
				}		
				else
				{
					edif=new Edificio(indirizzo);
					Modello.aggiungiEdificio(edif);
				}
				edif.inserisciLinkComprende(new TipoLinkContiene(area,edif));
			}
		} 
		catch (EccezionePrecondizioni e1) 
		{
			e1.printStackTrace();
			System.exit(1);
		}
	}

}
