package emergenza;

public class TipoLinkCollocazione 
{
	private final Persona pers;
	private final Edificio edif;
	
	public TipoLinkCollocazione(Persona pers, Edificio edif) throws EccezionePrecondizioni
	{
		if (pers==null || edif==null)
			throw(new EccezionePrecondizioni("Non ammessi valori nulli"));
		this.pers=pers;
		this.edif=edif;
	}

	public Persona getPersona() {
		return pers;
	}

	public Edificio getEdificio() {
		return edif;
	}

	public int hashCode() {
		return pers.hashCode()+edif.hashCode();
	}

	public boolean equals(Object obj) {
		if (getClass() != obj.getClass())
			return false;
		TipoLinkCollocazione other = (TipoLinkCollocazione) obj;
		return(pers==other.pers && edif==other.edif);
	}
	
}
