package attivitaatomiche;


import operazioniutente.OperazioniUtente;
import colonie.*;
import _framework.*;

public class ContaColoniePopolate implements Task {
	// questo task crea la regione e le relative colonie
	private Regione regione;
	private boolean eseguita = false;
	private int quanteColoniePopolate=0;
	
	
	public ContaColoniePopolate(Regione regione) {
		this.regione = regione;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita)
			return;
		eseguita = true;
		quanteColoniePopolate = OperazioniUtente.quanteColoniePopolate(regione);
	}
	
	public synchronized int getRisultato(){
		return quanteColoniePopolate;
	}

}
