package tris;

public class TipoLinkContiene 
{
	private final Scacchiera laScacchiera;
	private final Cella laCella;
	private final int x;
	private final int y;
	
	public TipoLinkContiene(Scacchiera s,Cella c,int x,int y) throws EccezionePrecondizioni
	{
		if (s==null | c==null)
			throw new EccezionePrecondizioni("Gli oggetti devono essere inizializzati");
		if (x<1 && x>3)
			throw new EccezionePrecondizioni("Posizione X errata");
		if (y<1 && y>3)
			throw new EccezionePrecondizioni("Posizione Y errata");
		this.laCella=c;
		this.laScacchiera=s;
		this.x=x;
		this.y=y;
	}
	
	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkContiene b = (TipoLinkContiene)o;
			return b.laScacchiera == laScacchiera && b.laCella == laCella && b.x == x && b.y == y;
		}
		else return false;
	}
	
	public int hashCode() {
		return laScacchiera.hashCode() + laCella.hashCode();
	}
	
	public Scacchiera getScacchiera() { return laScacchiera; }
	public Cella getCella() { return laCella; }

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}
		
}
