package processo;

import dominio.*;
import GUI.*;
import _framework.*;

public class CreaNuovoOrdine implements Task 
{
	private RecordOrdine record;
	private Utente utente;
	private Ordine ordine;
	private boolean eseguito;
	
	public CreaNuovoOrdine(RecordOrdine record, Utente utente) {
		this.record=record;
		this.utente=utente;
	}

	public synchronized void esegui(Executor e) 
	{
		if (eseguito)
			return;
		eseguito=true;
		ordine=new Ordine();
		Quotidiano q=Modello.getQuotidianoDalNome(record.getNomeQuotidiano());
		TipoLinkInclude link=new TipoLinkInclude(ordine,q,record.getNumeroCopie());
		q.inserisciLinkInclude(link);
	}

	public synchronized Ordine getOrdine() 
	{
		return(ordine);
	}

}
