package processo;

import GUI.AttivitaIO;
import GUI.RecordOrdine;
import _framework.Executor;
import dominio.*;

public class AttivitaPrincipale implements Runnable
{
	private Utente utente=null;
	
	public AttivitaPrincipale(Utente utente)
	{
		this.utente=utente;
	}
	

	public void run() 
	{
		RecordOrdine recOrdine=AttivitaIO.inserisciDatiOrdine(utente);
		CreaNuovoOrdine nuovoOrdine=new CreaNuovoOrdine(recOrdine,utente);
		Executor.perform(nuovoOrdine);
		Ordine ordine=nuovoOrdine.getOrdine();
		Thread t1=new Thread(new AttivitaGestioneOrdine(ordine,utente));
		t1.start();
		Thread t2=new Thread(new AttivitaVerificaAltroOrdine(utente));
		t2.start();
		
		try {
			t1.join();
			t2.join();
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
