package processo;

import _framework.Executor;
import dominio.Ordine;
import dominio.Utente;
import GUI.AttivitaIO;
import GUI.RecordOrdine;
import GUI.RecordPagamento;

public class AttivitaGestioneOrdine implements Runnable {

	Ordine ordine;
	Utente utente;
	
	public AttivitaGestioneOrdine(Ordine ordine, Utente utente) 
	{
		this.ordine=ordine;
		this.utente=utente;
	}

	public void run() 
	{
		VerificaPassword verPass;
		RecordPagamento recPagamento;
		do
		{
			recPagamento=AttivitaIO.chiediDatiPagamento(ordine);
			verPass=new VerificaPassword(recPagamento.getPassword(),utente);
			Executor.perform(verPass);
		}
		while (!verPass.isOk());
		Executor.perform(new AggiornaPagamento(recPagamento.getPassword(),ordine));
		Executor.perform(new InviaOrdine(utente,ordine));
	}

}
