package GUI;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import processo.AttivitaPrincipale;
import dominio.OperazioneUtente;
import dominio.Quotidiano;
import dominio.Utente;

public class PrincipaleListener implements ActionListener 
{
	public final static String NUOVOPROCESSO="P";
	public final static String STATISTICHE="X";
	
	public void actionPerformed(ActionEvent arg0) 
	{
		String com=arg0.getActionCommand();
		if (com==NUOVOPROCESSO)
			nuovoProcesso();
		else if (com==STATISTICHE)
			statistiche();
	}

	private void nuovoProcesso() {
		Object utenti[]=Modello.getUtenti().toArray();
		Utente ut=(Utente)
			JOptionPane.showInputDialog(null, "Selezionare un utente per l'ordine:", 
				"Nuovo Ordine", JOptionPane.PLAIN_MESSAGE, null, 
				utenti, utenti[0]);
		if (ut!=null)
		{
			Thread t=new Thread(new AttivitaPrincipale(ut));
			t.start();
		}
	}

	private void statistiche() {
		Object utenti[]=Modello.getQuotidiani().toArray();
		Quotidiano quot=(Quotidiano)
			JOptionPane.showInputDialog(null, "Selezionare un quotidiano:", 
				"Statistiche", JOptionPane.PLAIN_MESSAGE, null, 
				utenti, utenti[0]);
		if (quot!=null)
		{
			int quanteCopie=OperazioneUtente.quanteCopie(quot);
			String messaggio="Ad oggi sono state vendute "+quanteCopie+" del quotidiano "+quot.getNome();
			JOptionPane.showMessageDialog(null, messaggio);
		}	
	}

}
