package GUI;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import dominio.EccezionePrecondizioni;
import dominio.Ordine;
import dominio.Utente;

public class AttivitaIO 
{
	public static RecordOrdine inserisciDatiOrdine(Utente u) 
	{
		OrdineFrame frame=null;
		int numeroCopie=0;
		do
		{
			frame=new OrdineFrame(u);
			try 
			{
				synchronized(frame)
				{
					frame.wait();
				}
				numeroCopie=Integer.parseInt(frame.getNumeroCopie());
			} 
			catch (InterruptedException e) 
			{
				e.printStackTrace();
			}
			catch (NumberFormatException e)
			{
				JOptionPane.showMessageDialog(null, "Numero di copie errato");
			}
		} while(numeroCopie==0);
		String quotidiano=frame.getQuotidiano().getNome();
		return new RecordOrdine(quotidiano,numeroCopie);
	}

	public static boolean verificaSeAltroOrdine() 
	{
		int yn=JOptionPane.showConfirmDialog(null, "Effettuare altro ordine?","Gestione ordini",JOptionPane.YES_NO_OPTION);
		return yn==JOptionPane.YES_OPTION;
	}

	public static RecordPagamento chiediDatiPagamento(Ordine ordine) 
	{
		PagamentoFrame frame=null;
		try {
			frame=new PagamentoFrame(ordine);
			synchronized(frame)
			{
				frame.wait();
			}
		} catch (InterruptedException e) 
		{
			e.printStackTrace();
		} catch (EccezionePrecondizioni e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		RecordPagamento record=new RecordPagamento(frame.getIban(),frame.getPassword());
		return(record);
	}

}
