package GUI;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import dominio.EccezionePrecondizioni;
import dominio.Ordine;

class PagamentoListener implements ActionListener
{
	
	private PagamentoFrame frame;

	public PagamentoListener(PagamentoFrame frame)
	{
		this.frame=frame;
	}
	
	public void actionPerformed(ActionEvent arg0) 
	{
		synchronized(frame)
		{
			frame.notify();
		}
		frame.dispose();
	}
	
}

public class PagamentoFrame extends JFrame 
{
	private JLabel ibanLbl=new JLabel("Codice IBAN:");
	private JLabel passLbl=new JLabel("Password:");
	private JTextField ibanTxt=new JTextField(16);
	private JPasswordField passTxt=new JPasswordField(8);
	private JButton okBtn=new JButton("OK");
	private JPanel ibanPnl=new JPanel(new FlowLayout());
	private JPanel passPnl=new JPanel(new FlowLayout());
	private JPanel centroPnl=new JPanel(new FlowLayout());
	private JPanel sudPnl=new JPanel(new FlowLayout());
	
	public PagamentoFrame(Ordine x) throws EccezionePrecondizioni
	{
		super("Dati pagamento per ordine n "+x.getNumOrdine());
		sudPnl.add(okBtn);
		okBtn.addActionListener(new PagamentoListener(this));
		getContentPane().add(sudPnl,BorderLayout.SOUTH);
		ibanPnl.add(ibanLbl);
		ibanPnl.add(ibanTxt);
		centroPnl.add(ibanPnl);
		passPnl.add(passLbl);
		passPnl.add(passTxt);
		centroPnl.add(passPnl);
		centroPnl.add(new JLabel("Il pagamento ammonta a Euro "+x.prezzoTotale()));
		getContentPane().add(centroPnl,BorderLayout.CENTER);
		setSize(300,200);
		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
		setVisible(true);
	}
	
	public String getIban()
	{
		return ibanTxt.getText();
	}
	
	public String getPassword()
	{
		return new String(passTxt.getPassword());
	}
	

}
