package GUI;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.Vector;

import javax.swing.*;

import dominio.*;

class OrdineListener implements ActionListener
{
	
	private OrdineFrame frame;

	public OrdineListener(OrdineFrame frame)
	{
		this.frame=frame;
	}
	
	public void actionPerformed(ActionEvent arg0) 
	{
		synchronized(frame)
		{
			frame.notify();
		}
		frame.dispose();
	}
	
}

public class OrdineFrame extends JFrame 
{
	private final JComboBox quotidianoBox;
	private final JLabel quotidianoLbl=new JLabel("Quotidiano: ");
	private final JPanel quotidianoPnl=new JPanel();
	
	private final JLabel numeroCopieLbl=new JLabel("Numero copie:");
	private final JTextField numeroCopieTxt=new JTextField(2);
	private final JPanel numeroCopiePnl=new JPanel();
	
	private JButton okBtn=new JButton("OK");
	private JPanel centroPnl=new JPanel(new FlowLayout());
	private JPanel sudPnl=new JPanel(new FlowLayout());	

	public OrdineFrame(Utente x)
	{
		super("Inserimento ordine per utente "+x.getNome()+" "+x.getCognome());
		sudPnl.add(okBtn);
		okBtn.addActionListener(new OrdineListener(this));
		getContentPane().add(sudPnl,BorderLayout.SOUTH);
		quotidianoPnl.add(quotidianoLbl);
		
		Vector<Quotidiano> lista=new Vector<Quotidiano>();
		lista.addAll(Modello.getQuotidiani());

		quotidianoBox=new JComboBox(lista);
		quotidianoPnl.add(quotidianoBox);
		numeroCopiePnl.add(numeroCopieLbl);
		numeroCopiePnl.add(numeroCopieTxt);
		centroPnl.add(quotidianoPnl);
		centroPnl.add(numeroCopiePnl);
		getContentPane().add(centroPnl,BorderLayout.CENTER);
		setSize(300,200);
		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
		setVisible(true);
	}
	
	public Quotidiano getQuotidiano()
	{
		return (Quotidiano) quotidianoBox.getSelectedItem();
	}
	
	public String getNumeroCopie()
	{
		return numeroCopieTxt.getText();
	}
	
	
}
