package attivitacomposte;

import attivitaatomiche.*;
import _framework.*;
import _gestioneeventi.*;
import javax.swing.*;
import gui.*;

import colonie.*;

public class AttivitaPrincipale implements Runnable {
	private RecordRegione recordRegione;
	private Regione regione;
	private float densita = 0;
	
	public synchronized void run(){
		while (recordRegione == null){
			// Esce dal ciclo solo se l'utente ha inserito dati ragionevoli (cioe recordAttivita non e' null)
			recordRegione = AttivitaIO.leggiRegione();
		}
		// recordRegione contiene i dati della nuova regione da creare
		
		// Esegue il task per creare la regione e le relative celle
		CreaRegione taskCreaRegione = new CreaRegione(recordRegione);
		Executor.perform(taskCreaRegione);
		
		regione=taskCreaRegione.getRegione();
		
		// Inizializzazione environment con gli eventi iniziali
		InizializzaEnvironment taskInizializzaEnvironment = new InizializzaEnvironment(regione);
		Executor.perform(taskInizializzaEnvironment);

		// Mostra la finestra e rimane in attesa che sia premuto "Start"
		AttivitaIO.visualizzaFinestraRegione(taskCreaRegione.getFinestraRegione());
		
		// Avvia la simulazione
		EsecuzioneEnvironment.attivaListener();
		
		// Aspetta che l'utente richieda la chiusura della simulazione
		AttivitaIO.attendiFineSimulazione(taskCreaRegione.getFinestraRegione());
		
		// Esegue il task che interrompe le colonie
		EsecuzioneEnvironment.disattivaListener();
		
		// Esegue il task per contare quante colonie sono popolate
		CalcolaDensitaAbitativa taskCalcolaDensitaAbitativa = new CalcolaDensitaAbitativa(regione);
		Executor.perform(taskCalcolaDensitaAbitativa);
		densita = taskCalcolaDensitaAbitativa.getRisultato();
		
		// Stampa in output il numero di colonie popolate
		JOptionPane.showMessageDialog(taskCreaRegione.getFinestraRegione(), "La densita' abitativa della regione e': "+densita,"Densita' abitativa", JOptionPane.INFORMATION_MESSAGE);
	}
}
