package attivitaatomiche;


import operazioniutente.OperazioniUtente;
import colonie.*;
import _framework.*;

public class CalcolaDensitaAbitativa implements Task {
	// questo task calcola la densita abitativa di una regione
	private Regione regione;
	private boolean eseguita = false;
	private float densita=0;
	
	
	public CalcolaDensitaAbitativa(Regione regione) {
		this.regione = regione;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita)
			return;
		eseguita = true;
		densita = OperazioniUtente.densitaAbitativa(regione);
	}
	
	public synchronized float getRisultato(){
		return densita;
	}

}
