package it.uniroma1.dis.grafica;

import java.awt.*;
import java.awt.geom.Ellipse2D;

public class Ellipse extends Figure 
{
	private Color fillColor=null;
	private Ellipse2D.Float shape=null;
	private Point center=null;
	private int radius1,radius2;
	
	private void createShape()
	{
		if (center!=null)
			shape=new Ellipse2D.Float((float)center.getX()-radius1,
					(float)center.getY()-radius2,
					2*radius1,2*radius2);
		else
			shape=null;
	}
	
	public Ellipse(Point center, int radius1, int radius2)
	{
		this.center=center;
		this.radius1=radius1;
		this.radius2=radius2;
		createShape();	
	}
	
	public void draw(Graphics2D g2d) 
	{
		if (shape!=null)
		{
			g2d.setColor(this.lineColor);
			g2d.setStroke(new BasicStroke(this.lineSize));			
			g2d.draw(shape);
			if (fillColor!=null)
			{
				g2d.setColor(this.fillColor);
				g2d.fill(shape);
			}
		}
	}
	
	public boolean containsPoint(Point p)
	{
		return(shape.contains(p.getX(), p.getY()));
	}

	public void setFillColor(Color fillColor) 
	{
		this.fillColor = fillColor;
	}

	public Color getFillColor() {
		return fillColor;
	}

	public void setRadius1(int radius1) {
		this.radius1 = radius1;
		createShape();
	}

	public int getRadius1() {
		return radius1;
	}

	public void setRadius2(int radius2) {
		this.radius2 = radius2;
		createShape();
	}

	public int getRadius2() {
		return radius2;
	}

	public void setCenter(Point p) {
		this.center = p;
		createShape();
	}

	public Point getCenter() {
		return center;
	}

}
