package colonie;

import colonie.colonia.Colonia;

public class TipoLinkContiene {
	private final Regione regione;
	private final Colonia colonia;
	
	public TipoLinkContiene(Regione regione, Colonia colonia) throws EccezionePrecondizioni{
		if (regione == null || colonia == null){
			throw new EccezionePrecondizioni("Parametri nulli non ammessi");
		}
		this.regione=regione;
		this.colonia=colonia;
	}
	
	public Regione getRegione(){
		return regione;
	}
	
	public Colonia getColonia(){
		return colonia;
	}
	
	public int hashCode(){
		return colonia.hashCode() + regione.hashCode();
	}
	
	public boolean equals(Object o){
		if (o==null || (this.getClass() != o.getClass()))
			return false;
		
		TipoLinkContiene l = (TipoLinkContiene) o;
		return (regione == getRegione() && colonia == l.getColonia());
	}
}
