package attivitaatomiche;

import _framework.*;
import colonie.*;
import colonie.colonia.*;
import gui.*;

public class CreaRegione implements Task {
	// questo task crea la regione e le relative colonie
	private Regione regione;
	private RecordRegione recordRegione;
	private FinestraRegione finestraRegione;// SOLO PER SCOPI GRAFICI
	private boolean eseguita = false;

	public CreaRegione(RecordRegione recordRegione){
		this.recordRegione = recordRegione;
	}
	
	public synchronized void esegui(Executor e) {
		if (e == null || eseguita)
			return;
		eseguita = true;
		// Crea la regione
		regione = new Regione(recordRegione.getNome());
		
		// Crea la FinestraRegione SOLO PER SCOPI GRAFICI
		finestraRegione = new FinestraRegione(recordRegione.getNome(),recordRegione.getLato(), regione);// SOLO PER SCOPI GRAFICI
			
		// Crea le colonie da aggiungere alla regione, e ne configura le adiacenze
		int lato = recordRegione.getLato();
		Colonia[][] colonie = new Colonia[lato][lato];
		// (0,0) e' la colonia in alto a sx
		for(int i = 0; i < lato; i++)// i: righe
			for (int j = 0; j < lato; j++){// j: colonne
				Colonia nord = null;
				Colonia est = null;
				Colonia sud = null;
				Colonia ovest = null;
				// E' sufficiente impostare solo le adiacenze delle celle precedenti: abbiamo doppia responsabilita'
				if(i-1>=0)
					nord = colonie[i-1][j];
				if(j-1>=0)
					ovest = colonie[i][j-1];
				colonie[i][j]=nuovaColonia(nord,est,sud,ovest);
			}
		
		finestraRegione.prepara();// SOLO PER SCOPI GRAFICI: crea la finestra a partire dai dati delle celle
	}
		
	// Funzione di servizio
	private Colonia nuovaColonia(Colonia nord, Colonia est, Colonia sud, Colonia ovest){
		//Crea una nuova colonia e ne imposta le adiacenze secondo i parametri di input
		// nord: cella adiacente a nord, sud: cella adiacente a sud, etc...
		Colonia risultato = new Colonia(finestraRegione);		
		try{
			regione.inserisciLinkContiene(new TipoLinkContiene(regione,risultato));
			if (nord != null)
				risultato.inserisciLinkColonnaNord(new TipoLinkColonna(nord,risultato));// nord e' a nord di risultato
			if (sud != null)
				risultato.inserisciLinkColonnaSud(new TipoLinkColonna(sud,risultato));// sud e' a sud di risultato
			if (ovest != null)
				risultato.inserisciLinkRigaOvest(new TipoLinkRiga(risultato,ovest));// ovest e' a ovest di risultato
			if (est != null)
				risultato.inserisciLinkRigaEst(new TipoLinkRiga(est,risultato));// est e' a est di risultato
		}
		catch (EccezionePrecondizioni e){
			e.printStackTrace();
			System.exit(1);
		}
		
		return risultato;
	}
	//
	
	public synchronized Regione getRegione(){
		return regione;
	}

	public synchronized FinestraRegione getFinestraRegione(){
		return finestraRegione;
	}
}
