/*
 * Decompiled with CFR 0.152.
 */
package torus;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Robot2R {
    private Point2D Base;
    private Point2D Joint;
    private Point2D EndEffector;
    public Line2D Link1;
    public Line2D Link2;
    public Ellipse2D visJoint;
    public Ellipse2D visBase;
    public Ellipse2D visEndEffector;
    public int offsetX;
    public int offsetY;
    public int total_lenght;
    public int rad_vis;
    private int max_total_length;
    private int min_link_length;

    public Robot2R(int ofx, int ofy, int total) {
        this.offsetX = ofx;
        this.offsetY = ofy;
        this.total_lenght = total;
        this.max_total_length = 179;
        this.min_link_length = 1;
        this.rad_vis = 7;
        this.Base = new Point2D.Double(this.offsetX, this.offsetY);
        this.Joint = new Point2D.Double(this.offsetX + this.total_lenght / 2, this.offsetY);
        this.EndEffector = new Point2D.Double(this.offsetX + this.total_lenght, this.offsetY);
        this.Link1 = new Line2D.Double(this.Base, this.Joint);
        this.Link2 = new Line2D.Double(this.Joint, this.EndEffector);
        this.visJoint = new Ellipse2D.Double(this.Joint.getX() - (double)(this.rad_vis / 2), this.Joint.getY() - (double)(this.rad_vis / 2), this.rad_vis, this.rad_vis);
        this.visBase = new Ellipse2D.Double(this.Base.getX() - (double)(this.rad_vis / 2), this.Base.getY() - (double)(this.rad_vis / 2), this.rad_vis, this.rad_vis);
        this.visEndEffector = new Ellipse2D.Double(this.EndEffector.getX() - (double)(this.rad_vis / 2), this.EndEffector.getY() - (double)(this.rad_vis / 2), this.rad_vis, this.rad_vis);
    }

    public double getLinkLength_1() {
        return this.Base.distance(this.Joint);
    }

    public double getLinkLength_2() {
        return this.Joint.distance(this.EndEffector);
    }

    public void setConfig(int theta1, int theta2) {
        double x = this.getLinkLength_1() * Math.cos(Math.toRadians(-theta1));
        double y = this.getLinkLength_1() * Math.sin(Math.toRadians(-theta1));
        double x2 = this.getLinkLength_1() * Math.cos(Math.toRadians(-theta1)) + this.getLinkLength_2() * Math.cos(Math.toRadians(-theta1 - theta2));
        double y2 = this.getLinkLength_1() * Math.sin(Math.toRadians(-theta1)) + this.getLinkLength_2() * Math.sin(Math.toRadians(-theta1 - theta2));
        this.Joint.setLocation(x + (double)this.offsetX, y + (double)this.offsetY);
        this.EndEffector.setLocation(x2 + (double)this.offsetX, y2 + (double)this.offsetY);
        this.Link1.setLine(this.Base, this.Joint);
        this.Link2.setLine(this.Joint, this.EndEffector);
        this.visJoint.setFrame(this.Joint.getX() - (double)(this.rad_vis / 2), this.Joint.getY() - (double)(this.rad_vis / 2), this.rad_vis, this.rad_vis);
        this.visEndEffector.setFrame(this.EndEffector.getX() - (double)(this.rad_vis / 2), this.EndEffector.getY() - (double)(this.rad_vis / 2), this.rad_vis, this.rad_vis);
    }

    public void setTotal_lenght(int tl) {
        this.total_lenght = tl > this.max_total_length ? this.max_total_length : tl;
        this.setConfig(0, 0);
        this.Joint.setLocation(this.offsetX + this.total_lenght / 2, this.offsetY);
        this.EndEffector.setLocation(this.offsetX + this.total_lenght, this.offsetY);
    }

    public void setJoint_Position(int p) {
        int pose = this.total_lenght / 2;
        pose = p < this.min_link_length ? this.min_link_length : p;
        this.setConfig(0, 0);
        this.Joint.setLocation(this.offsetX + pose, this.offsetY);
    }
}

