/*
 * Decompiled with CFR 0.152.
 */
package torus;

import Test.Configuration;
import Test.NodeSet;
import Test.PlanningTools;
import Test.RRT;
import Test.RiccardoTree;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.AWTException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point3d;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import torus.CircleObstacle;
import torus.Obstacle;
import torus.PolygonObstacle;
import torus.Robot2R;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUI
extends JFrame {
    public Shape3D torus;
    public Appearance app;
    public Texture tex;
    public SimpleUniverse universe;
    public Scene t1;
    public Canvas3D canvas;
    public BranchGroup root;
    public TextureLoader texLoader;
    public int torus_flag;
    public int lineType = 3;
    public BasicStroke[] Line = new BasicStroke[7];
    public int resolution = 1;
    public Configuration init;
    public Configuration goal;
    public RRT rrt;
    public Configuration[] rrtPath;
    public ArrayList<Configuration> rrtPathAsArrayList;
    public AffineTransform translationMatrix;
    public Point oldMousePose;
    public int x_red_robot_old = 2;
    public int y_red_robot_old = 2;
    public int[] old_colors_torus_cSpace;
    Robot2R Robot;
    Robot r_mouse;
    CircleObstacle circle1;
    CircleObstacle circle2;
    CircleObstacle circle3;
    PolygonObstacle rectangle;
    PolygonObstacle triangle;
    BufferedImage c_space;
    BufferedImage c_space_torus;
    BufferedImage gradient;
    BufferedImage c_space_clear;
    BufferedImage red_dot_robot;
    boolean cf1;
    boolean cf2;
    boolean cf3;
    boolean tf1;
    boolean tf2;
    boolean tf3;
    boolean rf1;
    boolean rf2;
    boolean rf3;
    boolean rf4;
    private JCheckBox c_space_auto_update;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBoxCirc1;
    private JCheckBox jCheckBoxCirc2;
    private JCheckBox jCheckBoxCirc3;
    private JCheckBox jCheckBoxQuad;
    private JCheckBox jCheckBoxShowOnTorus;
    private JCheckBox jCheckBoxTri;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabel_Red_Dot_Robot;
    private JLabel jLabel_c_space;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JSlider jSlider3;
    private JSlider jSlider4;
    private JSlider jSlider5;
    private JSlider jSlider6;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField jTextField6;
    private JTextField jTextField7;
    private JTextField jTextField8;

    public GUI() throws AWTException {
        int j;
        int i;
        this.initComponents();
        this.setLayout(null);
        try {
            this.gradient = ImageIO.read(GUI.class.getClassLoader().getResource("torus/gradient.jpg"));
        }
        catch (IOException e) {
            // empty catch block
        }
        this.c_space_torus = new BufferedImage(360, 360, 1);
        this.c_space_clear = new BufferedImage(360, 360, 1);
        for (i = 1; i <= 360; ++i) {
            for (j = 1; j <= 360; ++j) {
                this.c_space_clear.setRGB(i - 1, j - 1, 0xFFFFFF);
            }
        }
        this.old_colors_torus_cSpace = new int[9];
        for (i = 0; i < 9; ++i) {
            this.old_colors_torus_cSpace[i] = 0xFFFFFF;
        }
        this.red_dot_robot = new BufferedImage(7, 7, 1);
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 7; ++j) {
                this.red_dot_robot.setRGB(i, j, 0xFF0000);
            }
        }
        ImageIcon img_red_dot_robot = new ImageIcon(this.red_dot_robot);
        this.jLabel_Red_Dot_Robot.setIcon(img_red_dot_robot);
        this.translationMatrix = new AffineTransform();
        this.r_mouse = new Robot();
        this.jSlider2.setPaintTicks(true);
        this.jSlider2.setMajorTickSpacing(90);
        this.jSlider2.setMinorTickSpacing(45);
        this.jSlider2.setPaintLabels(true);
        this.jSlider3.setPaintTicks(true);
        this.jSlider3.setMajorTickSpacing(90);
        this.jSlider3.setMinorTickSpacing(45);
        this.jSlider3.setPaintLabels(true);
        this.jSlider5.setPaintTicks(true);
        this.jSlider5.setMajorTickSpacing(42);
        this.jSlider5.setPaintLabels(true);
        this.jSlider4.setPaintTicks(true);
        this.jSlider4.setMajorTickSpacing(21);
        this.jSlider4.setPaintLabels(true);
        this.jSlider6.setPaintTicks(true);
        this.jSlider6.setMajorTickSpacing(1);
        this.jSlider6.setPaintLabels(true);
        this.Robot = new Robot2R(this.jPanel1.getHeight() / 2, this.jPanel1.getWidth() / 2, 100);
        this.Line[6] = new BasicStroke(7.0f);
        this.Line[5] = new BasicStroke(6.0f);
        this.Line[4] = new BasicStroke(5.0f);
        this.Line[3] = new BasicStroke(4.0f);
        this.Line[2] = new BasicStroke(3.0f);
        this.Line[1] = new BasicStroke(2.0f);
        this.Line[0] = new BasicStroke(1.0f);
        this.circle1 = new CircleObstacle(new Point2D.Double(120.0, 135.0), 30);
        this.circle2 = new CircleObstacle(new Point2D.Double(115.0, 240.0), 50);
        this.circle3 = new CircleObstacle(new Point2D.Double(270.0, 265.0), 70);
        this.triangle = new PolygonObstacle(new Point2D.Double(54.0, 53.0), new Point2D.Double(174.0, 41.0), new Point2D.Double(118.0, 90.0));
        this.rectangle = new PolygonObstacle(new Point2D.Double(193.0, 61.0), new Point2D.Double(314.0, 61.0), new Point2D.Double(268.0, 160.0), new Point2D.Double(193.0, 131.0));
        this.calculateC_Space();
        this.makeTorus();
        this.updateTorus();
    }

    @Override
    public void paint(Graphics g) {
        super.paintComponents(g);
        Graphics2D g2 = (Graphics2D)this.jPanel1.getGraphics();
        if (this.jCheckBoxQuad.isSelected()) {
            g2.setStroke(this.Line[0]);
            g2.setColor(Color.magenta);
            g2.draw(this.rectangle.shape);
            g2.fill(this.rectangle.shape);
            if (this.rf1) {
                g2.draw(this.rectangle.c1);
            }
            if (this.rf2) {
                g2.draw(this.rectangle.c2);
            }
            if (this.rf3) {
                g2.draw(this.rectangle.c3);
            }
            if (this.rf4) {
                g2.draw(this.rectangle.c4);
            }
        }
        if (this.jCheckBoxCirc1.isSelected()) {
            g2.setStroke(this.Line[0]);
            g2.setColor(Color.yellow);
            g2.draw(this.circle1.shape);
            g2.fill(this.circle1.shape);
            if (this.cf1) {
                g2.draw(this.circle1.cc);
            }
        }
        if (this.jCheckBoxCirc2.isSelected()) {
            g2.setStroke(this.Line[0]);
            g2.setColor(Color.gray);
            g2.draw(this.circle2.shape);
            g2.fill(this.circle2.shape);
            if (this.cf2) {
                g2.draw(this.circle2.cc);
            }
        }
        if (this.jCheckBoxCirc3.isSelected()) {
            g2.setStroke(this.Line[0]);
            g2.setColor(Color.gray);
            g2.draw(this.circle3.shape);
            g2.fill(this.circle3.shape);
            if (this.cf3) {
                g2.draw(this.circle3.cc);
            }
        }
        if (this.jCheckBoxTri.isSelected()) {
            g2.setStroke(this.Line[0]);
            g2.setColor(Color.cyan);
            g2.draw(this.triangle.shape);
            g2.fill(this.triangle.shape);
            if (this.tf1) {
                g2.draw(this.triangle.c1);
            }
            if (this.tf2) {
                g2.draw(this.triangle.c2);
            }
            if (this.tf3) {
                g2.draw(this.triangle.c3);
            }
        }
        g2.setColor(Color.black);
        g2.setStroke(this.Line[this.lineType]);
        g2.draw(this.Robot.Link1);
        g2.draw(this.Robot.Link2);
        g2.draw(this.Robot.visBase);
        g2.setColor(Color.GRAY);
        g2.draw(this.Robot.visEndEffector);
        g2.draw(this.Robot.visJoint);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSlider2 = new JSlider();
        this.jSlider3 = new JSlider();
        this.jSlider4 = new JSlider();
        this.jSlider5 = new JSlider();
        this.jSlider6 = new JSlider();
        this.jPanel4 = new JPanel();
        this.jCheckBoxTri = new JCheckBox();
        this.jCheckBoxQuad = new JCheckBox();
        this.jCheckBoxCirc1 = new JCheckBox();
        this.jCheckBoxCirc2 = new JCheckBox();
        this.jCheckBoxCirc3 = new JCheckBox();
        this.jPanel7 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.c_space_auto_update = new JCheckBox();
        this.jCheckBoxShowOnTorus = new JCheckBox();
        this.jPanel6 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jTextField3 = new JTextField();
        this.jTextField4 = new JTextField();
        this.jButton4 = new JButton();
        this.jSlider1 = new JSlider();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jTextField5 = new JTextField();
        this.jTextField6 = new JTextField();
        this.jTextField7 = new JTextField();
        this.jTextField8 = new JTextField();
        this.jButton3 = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel_Red_Dot_Robot = new JLabel();
        this.jLabel_c_space = new JLabel();
        this.jPanel2 = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("2R C-Space");
        this.setMinimumSize(new Dimension(842, 800));
        this.setResizable(false);
        this.getContentPane().setLayout(new AbsoluteLayout());
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setPreferredSize(new Dimension(360, 360));
        this.jPanel1.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GUI.this.jPanel1MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                GUI.this.jPanel1MouseReleased(evt);
            }

            public void mouseClicked(MouseEvent evt) {
                GUI.this.jPanel1MouseClicked(evt);
            }
        });
        this.jPanel1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                GUI.this.jPanel1MouseMoved(evt);
            }

            public void mouseDragged(MouseEvent evt) {
                GUI.this.jPanel1MouseDragged(evt);
            }
        });
        this.jPanel1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                GUI.this.jPanel1KeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                GUI.this.jPanel1KeyReleased(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(0, 358, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(0, 358, Short.MAX_VALUE));
        this.getContentPane().add((Component)this.jPanel1, new AbsoluteConstraints(20, 20, -1, -1));
        this.jTabbedPane1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel3.setLayout(new AbsoluteLayout());
        this.jLabel1.setText("Joint 1");
        this.jPanel3.add((Component)this.jLabel1, new AbsoluteConstraints(20, 30, -1, -1));
        this.jLabel2.setText("Joint 2");
        this.jPanel3.add((Component)this.jLabel2, new AbsoluteConstraints(20, 80, -1, -1));
        this.jLabel3.setText("Link Ratio");
        this.jPanel3.add((Component)this.jLabel3, new AbsoluteConstraints(20, 130, -1, -1));
        this.jLabel4.setText("Robot Length");
        this.jPanel3.add((Component)this.jLabel4, new AbsoluteConstraints(20, 180, -1, -1));
        this.jLabel5.setText("Line Weight");
        this.jPanel3.add((Component)this.jLabel5, new AbsoluteConstraints(20, 230, -1, -1));
        this.jSlider2.setMaximum(360);
        this.jSlider2.setPaintTicks(true);
        this.jSlider2.setValue(0);
        this.jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUI.this.jSlider2StateChanged(evt);
            }
        });
        this.jPanel3.add((Component)this.jSlider2, new AbsoluteConstraints(120, 25, 230, -1));
        this.jSlider3.setMaximum(360);
        this.jSlider3.setPaintTicks(true);
        this.jSlider3.setValue(0);
        this.jSlider3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUI.this.jSlider3StateChanged(evt);
            }
        });
        this.jPanel3.add((Component)this.jSlider3, new AbsoluteConstraints(120, 75, 230, -1));
        this.jSlider4.setMinimum(2);
        this.jSlider4.setPaintTicks(true);
        this.jSlider4.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUI.this.jSlider4StateChanged(evt);
            }
        });
        this.jPanel3.add((Component)this.jSlider4, new AbsoluteConstraints(120, 125, 230, -1));
        this.jSlider5.setMaximum(182);
        this.jSlider5.setMinimum(2);
        this.jSlider5.setPaintTicks(true);
        this.jSlider5.setValue(100);
        this.jSlider5.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUI.this.jSlider5StateChanged(evt);
            }
        });
        this.jPanel3.add((Component)this.jSlider5, new AbsoluteConstraints(120, 175, 230, -1));
        this.jSlider6.setMaximum(7);
        this.jSlider6.setMinimum(1);
        this.jSlider6.setPaintTicks(true);
        this.jSlider6.setSnapToTicks(true);
        this.jSlider6.setValue(3);
        this.jSlider6.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUI.this.jSlider6StateChanged(evt);
            }
        });
        this.jPanel3.add((Component)this.jSlider6, new AbsoluteConstraints(120, 225, 230, -1));
        this.jTabbedPane1.addTab("Robot", this.jPanel3);
        this.jPanel4.setLayout(new AbsoluteLayout());
        this.jCheckBoxTri.setText("Triangle Obstacle");
        this.jCheckBoxTri.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUI.this.jCheckBoxTriStateChanged(evt);
            }
        });
        this.jPanel4.add((Component)this.jCheckBoxTri, new AbsoluteConstraints(50, 30, -1, -1));
        this.jCheckBoxQuad.setText("Rectangle Obstacle");
        this.jCheckBoxQuad.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUI.this.jCheckBoxQuadStateChanged(evt);
            }
        });
        this.jPanel4.add((Component)this.jCheckBoxQuad, new AbsoluteConstraints(50, 80, -1, -1));
        this.jCheckBoxCirc1.setText("Circular Obstacle 1");
        this.jCheckBoxCirc1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUI.this.jCheckBoxCirc1StateChanged(evt);
            }
        });
        this.jPanel4.add((Component)this.jCheckBoxCirc1, new AbsoluteConstraints(50, 130, -1, -1));
        this.jCheckBoxCirc2.setText("Circular Obstacle 2");
        this.jCheckBoxCirc2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUI.this.jCheckBoxCirc2StateChanged(evt);
            }
        });
        this.jPanel4.add((Component)this.jCheckBoxCirc2, new AbsoluteConstraints(50, 180, -1, -1));
        this.jCheckBoxCirc3.setText("Circular Obstacle 3");
        this.jCheckBoxCirc3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUI.this.jCheckBoxCirc3StateChanged(evt);
            }
        });
        this.jPanel4.add((Component)this.jCheckBoxCirc3, new AbsoluteConstraints(50, 230, -1, -1));
        this.jTabbedPane1.addTab("Obstacles", this.jPanel4);
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setLabel("Show Path in C-Space");
        this.jCheckBox2.setSelected(true);
        this.jCheckBox2.setText("High Resolution");
        this.jCheckBox2.setToolTipText("<html>\nDetermines if the configuratio space is calculated with high resolution of not.\n<br>If you have slow computer maybe it's better to keep this unchecked.\n<br>Please metion that this setting, has no effect on the accuracy of RRT.");
        this.jCheckBox2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUI.this.jCheckBox2StateChanged(evt);
            }
        });
        this.c_space_auto_update.setSelected(true);
        this.c_space_auto_update.setText("Auto update the c-space");
        this.c_space_auto_update.setToolTipText("<html>\nCheck this if you want to update the configuration space as you change the worksapce\n<br>i.e. moveing the obstacles or changing the the robot size and link length.");
        this.c_space_auto_update.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUI.this.c_space_auto_updateStateChanged(evt);
            }
        });
        this.jCheckBoxShowOnTorus.setSelected(true);
        this.jCheckBoxShowOnTorus.setText("Show Robot Configuration on Torus");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(1).add(jPanel7Layout.createSequentialGroup().add(46, 46, 46).add(jPanel7Layout.createParallelGroup(1).add(this.jCheckBoxShowOnTorus).add(this.c_space_auto_update).add(this.jCheckBox2).add(this.jCheckBox1)).addContainerGap(94, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(1).add(jPanel7Layout.createSequentialGroup().add(34, 34, 34).add(this.jCheckBox1).add(27, 27, 27).add(this.jCheckBox2).add(27, 27, 27).add(this.c_space_auto_update).add(30, 30, 30).add(this.jCheckBoxShowOnTorus).addContainerGap(102, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Settings", this.jPanel7);
        this.jPanel6.setToolTipText("<html>\n<p>Modified RRT\n<ol>\n<li><b>Goal Bias:</b> With this probability, in each iteration, Q<sub>goal</sub> is considered as Q<sub>rand</sub>.</li>\n<li><b>Threshold:</b> If the distance between Q<sub>goal</sub> and Q<sub>new</sub> is less than threshold, RRT tries to connect them.</li>\n<li><b>Delta:</b> The amount of extension from Q<sub>near</sub> toward Q<sub>rand</sub> to achieve Q<sub>new</sub>.</li>\n</ol>\n</html> ");
        this.jPanel6.setLayout(new AbsoluteLayout());
        this.jButton1.setText("Init");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.jButton1, new AbsoluteConstraints(60, 20, -1, -1));
        this.jButton2.setText("Goal");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.jButton2, new AbsoluteConstraints(60, 50, -1, -1));
        this.jPanel6.add((Component)this.jTextField1, new AbsoluteConstraints(160, 20, 60, -1));
        this.jPanel6.add((Component)this.jTextField2, new AbsoluteConstraints(250, 20, 60, -1));
        this.jPanel6.add((Component)this.jTextField3, new AbsoluteConstraints(160, 50, 60, -1));
        this.jPanel6.add((Component)this.jTextField4, new AbsoluteConstraints(250, 50, 60, -1));
        this.jButton4.setText("Find Path!");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.jButton4, new AbsoluteConstraints(200, 230, 110, -1));
        this.jSlider1.setValue(1);
        this.jSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUI.this.jSlider1StateChanged(evt);
            }
        });
        this.jPanel6.add((Component)this.jSlider1, new AbsoluteConstraints(20, 270, 370, -1));
        this.jLabel7.setText("q2");
        this.jPanel6.add((Component)this.jLabel7, new AbsoluteConstraints(230, 50, 20, 30));
        this.jLabel8.setText("q1");
        this.jPanel6.add((Component)this.jLabel8, new AbsoluteConstraints(138, 26, 20, 20));
        this.jLabel9.setText("q1");
        this.jPanel6.add((Component)this.jLabel9, new AbsoluteConstraints(140, 50, 20, 30));
        this.jLabel10.setText("q2");
        this.jPanel6.add((Component)this.jLabel10, new AbsoluteConstraints(230, 20, 20, 30));
        this.jLabel11.setText("Goal Bias");
        this.jPanel6.add((Component)this.jLabel11, new AbsoluteConstraints(70, 100, -1, 30));
        this.jLabel12.setText("Threshold");
        this.jPanel6.add((Component)this.jLabel12, new AbsoluteConstraints(70, 130, -1, 30));
        this.jLabel13.setText("Delta");
        this.jPanel6.add((Component)this.jLabel13, new AbsoluteConstraints(70, 160, -1, 30));
        this.jLabel14.setText("Iterations");
        this.jPanel6.add((Component)this.jLabel14, new AbsoluteConstraints(70, 190, -1, 30));
        this.jTextField5.setText("0.25");
        this.jPanel6.add((Component)this.jTextField5, new AbsoluteConstraints(160, 100, 150, -1));
        this.jTextField6.setText("50");
        this.jPanel6.add((Component)this.jTextField6, new AbsoluteConstraints(160, 130, 150, -1));
        this.jTextField7.setText("20");
        this.jPanel6.add((Component)this.jTextField7, new AbsoluteConstraints(160, 160, 150, -1));
        this.jTextField8.setText("25000");
        this.jPanel6.add((Component)this.jTextField8, new AbsoluteConstraints(160, 190, 150, -1));
        this.jButton3.setText("Clear Path");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.jButton3, new AbsoluteConstraints(70, 230, 110, -1));
        this.jTabbedPane1.addTab("RRT", this.jPanel6);
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("<html> <div align=\"center\">  <i>2R C-Space (Alpha Release)</i><br><br><br> Designed and developed by <i><b>Pouya Mohammadi</b></i>   <br> <br><br> This software is created only for educational purposes <br>   Feel free to share it under this condition <br><br><br>  <br><br><br> If you have any feedback, suggestions or bug-report<br> do not hesitate to send an email to:");
        this.jLabel6.setVerticalAlignment(1);
        this.jLabel15.setIcon(new ImageIcon(this.getClass().getResource("/torus/Untitled2.png")));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(1).add(jPanel5Layout.createSequentialGroup().addContainerGap().add(jPanel5Layout.createParallelGroup(1).add(jPanel5Layout.createSequentialGroup().add(this.jLabel6, -1, 357, Short.MAX_VALUE).addContainerGap()).add(2, jPanel5Layout.createSequentialGroup().add(this.jLabel15).add(98, 98, 98)))));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(1).add(jPanel5Layout.createSequentialGroup().addContainerGap().add(this.jLabel6, -2, 255, -2).addPreferredGap(0).add(this.jLabel15).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("About", this.jPanel5);
        this.getContentPane().add((Component)this.jTabbedPane1, new AbsoluteConstraints(400, 20, 420, 360));
        this.jLabel_Red_Dot_Robot.setDoubleBuffered(true);
        this.jLabel_Red_Dot_Robot.setIgnoreRepaint(true);
        this.getContentPane().add((Component)this.jLabel_Red_Dot_Robot, new AbsoluteConstraints(17, 397, 7, 7));
        this.jLabel_c_space.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel_c_space.setCursor(new Cursor(1));
        this.jLabel_c_space.setDoubleBuffered(true);
        this.jLabel_c_space.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GUI.this.jLabel_c_spaceMouseClicked(evt);
            }
        });
        this.jLabel_c_space.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                GUI.this.jLabel_c_spaceMouseDragged(evt);
            }
        });
        this.getContentPane().add((Component)this.jLabel_c_space, new AbsoluteConstraints(20, 400, 360, 360));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(0, 418, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(0, 358, Short.MAX_VALUE));
        this.getContentPane().add((Component)this.jPanel2, new AbsoluteConstraints(400, 400, 420, 360));
        this.pack();
    }

    private void jLabel_c_spaceMouseDragged(MouseEvent evt) {
        Point pose = evt.getPoint();
        if (pose.x == 360) {
            this.r_mouse.mouseMove(this.getX() + this.jLabel_c_space.getX() + 1, this.getY() + this.jLabel_c_space.getY() + 22 + pose.y);
        }
        if (pose.x == 0) {
            this.r_mouse.mouseMove(this.getX() + this.jLabel_c_space.getX() + 359, this.getY() + this.jLabel_c_space.getY() + 22 + pose.y);
        }
        if (pose.y == 360) {
            this.r_mouse.mouseMove(this.getX() + this.jLabel_c_space.getX() + pose.x, this.getY() + this.jLabel_c_space.getY() + 22 + 1);
        }
        if (pose.y == 0) {
            this.r_mouse.mouseMove(this.getX() + this.jLabel_c_space.getX() + pose.x, this.getY() + this.jLabel_c_space.getY() + 359 + 22);
        }
        this.jSlider3.setValue(pose.y);
        this.jSlider2.setValue(pose.x);
        this.Robot.setConfig(pose.x, pose.y);
        this.repaint();
        this.updateTorus();
    }

    private void jPanel1MouseDragged(MouseEvent evt) {
        double q1;
        double q2;
        double s2;
        double c2;
        Point pose_inv;
        Point2D.Double pose = new Point2D.Double(evt.getX(), evt.getY());
        boolean someone_is_glued_local = false;
        if (!someone_is_glued_local && this.jCheckBoxCirc1.isSelected()) {
            if (this.circle1.cc.contains(pose)) {
                this.circle1.setRadius((int)(((Point2D)pose).getX() - this.circle1.center.getX()));
                someone_is_glued_local = true;
            }
            if (this.circle1.getShape().contains(pose)) {
                this.circle1.setCenter(pose);
                someone_is_glued_local = true;
            }
        }
        if (!someone_is_glued_local && this.jCheckBoxCirc2.isSelected()) {
            if (this.circle2.cc.contains(pose)) {
                this.circle2.setRadius((int)(((Point2D)pose).getX() - this.circle2.center.getX()));
                someone_is_glued_local = true;
            }
            if (this.circle2.getShape().contains(pose)) {
                this.circle2.setCenter(pose);
                someone_is_glued_local = true;
            }
        }
        if (!someone_is_glued_local && this.jCheckBoxCirc3.isSelected()) {
            if (this.circle3.cc.contains(pose)) {
                this.circle3.setRadius((int)(((Point2D)pose).getX() - this.circle3.center.getX()));
                someone_is_glued_local = true;
            }
            if (this.circle3.getShape().contains(pose)) {
                this.circle3.setCenter(pose);
                someone_is_glued_local = true;
            }
        }
        if (!someone_is_glued_local && this.jCheckBoxTri.isSelected()) {
            if (this.triangle.c1.contains(pose)) {
                this.triangle.setPoint(1, pose);
                someone_is_glued_local = true;
            }
            if (this.triangle.c2.contains(pose)) {
                this.triangle.setPoint(2, pose);
                someone_is_glued_local = true;
            }
            if (this.triangle.c3.contains(pose)) {
                this.triangle.setPoint(3, pose);
                someone_is_glued_local = true;
            }
            if (this.triangle.getShape().contains(pose) && !someone_is_glued_local) {
                this.translationMatrix.setToTranslation(((Point2D)pose).getX() - (double)this.oldMousePose.x, ((Point2D)pose).getY() - (double)this.oldMousePose.y);
                this.triangle.getShape().transform(this.translationMatrix);
                this.triangle.setPoint(1, this.triangle.P1.getX() + ((Point2D)pose).getX() - (double)this.oldMousePose.x, this.triangle.P1.getY() + ((Point2D)pose).getY() - (double)this.oldMousePose.y);
                this.triangle.setPoint(2, this.triangle.P2.getX() + ((Point2D)pose).getX() - (double)this.oldMousePose.x, this.triangle.P2.getY() + ((Point2D)pose).getY() - (double)this.oldMousePose.y);
                this.triangle.setPoint(3, this.triangle.P3.getX() + ((Point2D)pose).getX() - (double)this.oldMousePose.x, this.triangle.P3.getY() + ((Point2D)pose).getY() - (double)this.oldMousePose.y);
                this.oldMousePose.x = evt.getX();
                this.oldMousePose.y = evt.getY();
                someone_is_glued_local = true;
            }
        }
        if (!someone_is_glued_local && this.jCheckBoxQuad.isSelected()) {
            if (this.rectangle.c1.contains(pose)) {
                this.rectangle.setPoint(1, pose);
                someone_is_glued_local = true;
            }
            if (this.rectangle.c2.contains(pose)) {
                this.rectangle.setPoint(2, pose);
                someone_is_glued_local = true;
            }
            if (this.rectangle.c3.contains(pose)) {
                this.rectangle.setPoint(3, pose);
                someone_is_glued_local = true;
            }
            if (this.rectangle.c4.contains(pose)) {
                this.rectangle.setPoint(4, pose);
                someone_is_glued_local = true;
            }
            if (this.rectangle.getShape().contains(pose) && !someone_is_glued_local) {
                this.translationMatrix.setToTranslation(((Point2D)pose).getX() - (double)this.oldMousePose.x, ((Point2D)pose).getY() - (double)this.oldMousePose.y);
                this.rectangle.getShape().transform(this.translationMatrix);
                this.rectangle.setPoint(1, this.rectangle.P1.getX() + ((Point2D)pose).getX() - (double)this.oldMousePose.x, this.rectangle.P1.getY() + ((Point2D)pose).getY() - (double)this.oldMousePose.y);
                this.rectangle.setPoint(2, this.rectangle.P2.getX() + ((Point2D)pose).getX() - (double)this.oldMousePose.x, this.rectangle.P2.getY() + ((Point2D)pose).getY() - (double)this.oldMousePose.y);
                this.rectangle.setPoint(3, this.rectangle.P3.getX() + ((Point2D)pose).getX() - (double)this.oldMousePose.x, this.rectangle.P3.getY() + ((Point2D)pose).getY() - (double)this.oldMousePose.y);
                this.rectangle.setPoint(4, this.rectangle.P4.getX() + ((Point2D)pose).getX() - (double)this.oldMousePose.x, this.rectangle.P4.getY() + ((Point2D)pose).getY() - (double)this.oldMousePose.y);
                this.oldMousePose.x = evt.getX();
                this.oldMousePose.y = evt.getY();
                someone_is_glued_local = true;
            }
        }
        this.repaint();
        if (this.c_space_auto_update.isSelected() && someone_is_glued_local) {
            this.calculateC_Space();
            this.updateTorus();
        }
        if (!someone_is_glued_local && evt.getButton() == 1) {
            someone_is_glued_local = true;
            pose_inv = new Point(evt.getX() - 180, evt.getY() - 180);
            c2 = (Math.pow(pose_inv.getX(), 2.0) + Math.pow(pose_inv.getY(), 2.0) - Math.pow(this.Robot.getLinkLength_1(), 2.0) - Math.pow(this.Robot.getLinkLength_2(), 2.0)) / (2.0 * this.Robot.getLinkLength_1() * this.Robot.getLinkLength_2());
            s2 = Math.sqrt(1.0 - Math.pow(c2, 2.0));
            q2 = Math.atan2(s2, c2);
            q1 = Math.atan2(pose_inv.getY(), pose_inv.getX()) - Math.atan2(this.Robot.getLinkLength_2() * s2, this.Robot.getLinkLength_1() + this.Robot.getLinkLength_2() * c2);
            q1 = -Math.toDegrees(q1);
            q2 = -Math.toDegrees(q2);
            this.Robot.setConfig((int)q1, (int)q2);
            if (q1 < 0.0) {
                q1 = 359.0 + q1;
            }
            if (q2 < 0.0) {
                q2 = 359.0 + q2;
            }
            this.jSlider2.setValue((int)q1);
            this.jSlider3.setValue((int)q2);
            this.repaint();
        }
        if (!someone_is_glued_local && evt.getButton() == 3) {
            someone_is_glued_local = true;
            pose_inv = new Point(evt.getX() - 180, evt.getY() - 180);
            c2 = (Math.pow(pose_inv.getX(), 2.0) + Math.pow(pose_inv.getY(), 2.0) - Math.pow(this.Robot.getLinkLength_1(), 2.0) - Math.pow(this.Robot.getLinkLength_2(), 2.0)) / (2.0 * this.Robot.getLinkLength_1() * this.Robot.getLinkLength_2());
            s2 = -Math.sqrt(1.0 - Math.pow(c2, 2.0));
            q2 = Math.atan2(s2, c2);
            q1 = Math.atan2(pose_inv.getY(), pose_inv.getX()) - Math.atan2(this.Robot.getLinkLength_2() * s2, this.Robot.getLinkLength_1() + this.Robot.getLinkLength_2() * c2);
            q1 = -Math.toDegrees(q1);
            q2 = -Math.toDegrees(q2);
            this.Robot.setConfig((int)q1, (int)q2);
            if (q1 < 0.0) {
                q1 = 359.0 + q1;
            }
            if (q2 < 0.0) {
                q2 = 359.0 + q2;
            }
            this.jSlider2.setValue((int)q1);
            this.jSlider3.setValue((int)q2);
            this.repaint();
        }
    }

    private void jPanel1MouseMoved(MouseEvent evt) {
        Point2D.Double pose = new Point2D.Double(evt.getX(), evt.getY());
        if (this.circle1.getShape().contains(pose)) {
            this.cf1 = true;
            this.tf2 = false;
            this.tf3 = false;
            this.rf1 = false;
            this.rf2 = false;
            this.rf3 = false;
            this.rf4 = false;
            this.tf1 = false;
            this.cf2 = false;
            this.cf3 = false;
        }
        if (this.circle2.getShape().contains(pose)) {
            this.cf2 = true;
            this.tf2 = false;
            this.tf3 = false;
            this.rf1 = false;
            this.rf2 = false;
            this.rf3 = false;
            this.rf4 = false;
            this.tf1 = false;
            this.cf1 = false;
            this.cf3 = false;
        }
        if (this.circle3.getShape().contains(pose)) {
            this.cf3 = true;
            this.tf2 = false;
            this.tf3 = false;
            this.rf1 = false;
            this.rf2 = false;
            this.rf3 = false;
            this.rf4 = false;
            this.tf1 = false;
            this.cf2 = false;
            this.cf1 = false;
        }
        if (this.triangle.c1.contains(pose)) {
            this.tf1 = true;
            this.tf2 = false;
            this.tf3 = false;
            this.rf1 = false;
            this.rf2 = false;
            this.rf3 = false;
            this.rf4 = false;
            this.cf1 = false;
            this.cf2 = false;
            this.cf3 = false;
        }
        if (this.triangle.c2.contains(pose)) {
            this.tf2 = true;
            this.tf1 = false;
            this.tf3 = false;
            this.rf1 = false;
            this.rf2 = false;
            this.rf3 = false;
            this.rf4 = false;
            this.cf1 = false;
            this.cf2 = false;
            this.cf3 = false;
        }
        if (this.triangle.c3.contains(pose)) {
            this.tf3 = true;
            this.tf2 = false;
            this.tf1 = false;
            this.rf1 = false;
            this.rf2 = false;
            this.rf3 = false;
            this.rf4 = false;
            this.cf1 = false;
            this.cf2 = false;
            this.cf3 = false;
        }
        if (this.rectangle.c1.contains(pose)) {
            this.rf1 = true;
            this.tf2 = false;
            this.tf3 = false;
            this.tf1 = false;
            this.rf2 = false;
            this.rf3 = false;
            this.rf4 = false;
            this.cf1 = false;
            this.cf2 = false;
            this.cf3 = false;
        }
        if (this.rectangle.c2.contains(pose)) {
            this.rf2 = true;
            this.tf2 = false;
            this.tf3 = false;
            this.rf1 = false;
            this.tf1 = false;
            this.rf3 = false;
            this.rf4 = false;
            this.cf1 = false;
            this.cf2 = false;
            this.cf3 = false;
        }
        if (this.rectangle.c3.contains(pose)) {
            this.rf3 = true;
            this.tf2 = false;
            this.tf3 = false;
            this.rf1 = false;
            this.rf2 = false;
            this.tf1 = false;
            this.rf4 = false;
            this.cf1 = false;
            this.cf2 = false;
            this.cf3 = false;
        }
        if (this.rectangle.c4.contains(pose)) {
            this.rf4 = true;
            this.tf2 = false;
            this.tf3 = false;
            this.rf1 = false;
            this.rf2 = false;
            this.rf3 = false;
            this.tf1 = false;
            this.cf1 = false;
            this.cf2 = false;
            this.cf3 = false;
        }
        this.repaint();
    }

    private void jSlider2StateChanged(ChangeEvent evt) {
        this.Robot.setConfig(this.jSlider2.getValue(), this.jSlider3.getValue());
        this.setRedDotRobotPose(this.jSlider2.getValue(), this.jSlider3.getValue());
        if (this.jCheckBoxShowOnTorus.isSelected()) {
            this.showRobotAsRedDot(this.jSlider2.getValue(), this.jSlider3.getValue());
        }
        this.repaint();
    }

    private void jSlider3StateChanged(ChangeEvent evt) {
        this.Robot.setConfig(this.jSlider2.getValue(), this.jSlider3.getValue());
        this.setRedDotRobotPose(this.jSlider2.getValue(), this.jSlider3.getValue());
        if (this.jCheckBoxShowOnTorus.isSelected()) {
            this.showRobotAsRedDot(this.jSlider2.getValue(), this.jSlider3.getValue());
        }
        this.repaint();
    }

    private void jSlider5StateChanged(ChangeEvent evt) {
        this.Robot.setTotal_lenght(this.jSlider5.getValue());
        this.repaint();
        if (this.c_space_auto_update.isSelected()) {
            this.calculateC_Space();
            this.updateTorus();
        }
        this.jSlider4.setMaximum(this.jSlider5.getValue() - 2);
        this.jSlider4.setValue(this.jSlider4.getMaximum() / 2);
    }

    private void jSlider6StateChanged(ChangeEvent evt) {
        this.lineType = this.jSlider6.getValue() - 1;
        this.repaint();
    }

    private void jSlider4StateChanged(ChangeEvent evt) {
        this.Robot.setJoint_Position(this.jSlider4.getValue());
        this.repaint();
        if (this.c_space_auto_update.isSelected()) {
            this.calculateC_Space();
            this.updateTorus();
        }
    }

    private void jCheckBoxTriStateChanged(ChangeEvent evt) {
        if (this.c_space_auto_update.isSelected()) {
            this.repaint();
            this.calculateC_Space();
            this.updateTorus();
        }
    }

    private void jCheckBoxQuadStateChanged(ChangeEvent evt) {
        if (this.c_space_auto_update.isSelected()) {
            this.repaint();
            this.calculateC_Space();
            this.updateTorus();
        }
    }

    private void jCheckBoxCirc1StateChanged(ChangeEvent evt) {
        if (this.c_space_auto_update.isSelected()) {
            this.repaint();
            this.calculateC_Space();
            this.updateTorus();
        }
    }

    private void jLabel_c_spaceMouseClicked(MouseEvent evt) {
        Point pose = new Point(evt.getX(), evt.getY());
        this.jSlider3.setValue(pose.y);
        this.jSlider2.setValue(pose.x);
        this.Robot.setConfig(pose.x, pose.y);
        this.repaint();
    }

    private void jCheckBoxCirc2StateChanged(ChangeEvent evt) {
        if (this.c_space_auto_update.isSelected()) {
            this.repaint();
            this.calculateC_Space();
            this.updateTorus();
        }
    }

    private void jCheckBoxCirc3StateChanged(ChangeEvent evt) {
        if (this.c_space_auto_update.isSelected()) {
            this.repaint();
            this.calculateC_Space();
            this.updateTorus();
        }
    }

    private void c_space_auto_updateStateChanged(ChangeEvent evt) {
        if (this.c_space_auto_update.isSelected()) {
            this.calculateC_Space();
            this.updateTorus();
        } else {
            ImageIcon icon = new ImageIcon();
            icon.setImage(this.c_space_clear);
            this.jLabel_c_space.setIcon(icon);
            this.updateTorus();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jTextField1.setText(String.valueOf(this.jSlider2.getValue()));
        this.jTextField2.setText(String.valueOf(this.jSlider3.getValue()));
        this.init = new Configuration(Integer.valueOf(this.jTextField1.getText()), Integer.valueOf(this.jTextField2.getText()));
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.jTextField3.setText(String.valueOf(this.jSlider2.getValue()));
        this.jTextField4.setText(String.valueOf(this.jSlider3.getValue()));
        this.goal = new Configuration(Integer.valueOf(this.jTextField3.getText()), Integer.valueOf(this.jTextField4.getText()));
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        ArrayList<Obstacle> a = new ArrayList<Obstacle>();
        if (this.jCheckBoxCirc1.isSelected()) {
            a.add(this.circle1);
        }
        if (this.jCheckBoxCirc2.isSelected()) {
            a.add(this.circle2);
        }
        if (this.jCheckBoxCirc3.isSelected()) {
            a.add(this.circle3);
        }
        if (this.jCheckBoxQuad.isSelected()) {
            a.add(this.rectangle);
        }
        if (this.jCheckBoxTri.isSelected()) {
            a.add(this.triangle);
        }
        double bias_ = Double.valueOf(this.jTextField5.getText());
        double threshold_ = Double.valueOf(this.jTextField6.getText());
        double delta_ = Double.valueOf(this.jTextField7.getText());
        int iterations_ = Integer.valueOf(this.jTextField8.getText());
        long t1_ = System.currentTimeMillis();
        this.rrt = new RRT(this.init, this.goal, this.Robot, a, bias_, threshold_, delta_, iterations_);
        long t2_ = System.currentTimeMillis();
        if (this.rrt.findGoal) {
            this.jCheckBox1.setSelected(true);
            this.plotTree(this.rrt.nodeSET);
            this.showQiQf(this.init, this.goal);
            this.rrtPathAsArrayList = new ArrayList();
            ArrayList<Configuration> path_conf_nodes = this.rrt.getPath();
            for (int i = 0; i < path_conf_nodes.size() - 1; ++i) {
                Configuration parentNode = path_conf_nodes.get(i);
                Configuration thisNode = path_conf_nodes.get(i + 1);
                Configuration[] localPath = PlanningTools.getDirectPath(parentNode, thisNode);
                this.rrtPathAsArrayList.addAll(Arrays.asList(localPath));
            }
            this.jSlider1.setMaximum(this.rrtPathAsArrayList.size());
            this.jSlider1.setMinimum(1);
            this.jSlider1.setValue(1);
            this.repaint();
            this.updateTorus();
            String msg = "Number of nodes in the RRT tree: " + this.rrt.new_tree.getAllNodes().size() + ".\n";
            msg = msg + "Number of nodes in the path tree: " + path_conf_nodes.size() + ".\n";
            msg = msg + "Time elapsed to find the path: " + (t2_ - t1_) + " milliseconds.";
            JOptionPane.showMessageDialog(null, msg, "Path found :D", 1);
        }
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        if (this.rrt.findGoal) {
            int TH1 = this.rrtPathAsArrayList.get((int)Math.abs((int)(this.rrtPathAsArrayList.size() - this.jSlider1.getValue()))).theta1;
            int TH2 = this.rrtPathAsArrayList.get((int)Math.abs((int)(this.rrtPathAsArrayList.size() - this.jSlider1.getValue()))).theta2;
            this.Robot.setConfig(TH1, TH2);
            this.setRedDotRobotPose(TH1, TH2);
            this.showRobotAsRedDot(TH1, TH2);
            this.repaint();
        }
    }

    private void jPanel1MousePressed(MouseEvent evt) {
        this.oldMousePose = evt.getPoint();
    }

    private void jPanel1MouseReleased(MouseEvent evt) {
    }

    private void jCheckBox2StateChanged(ChangeEvent evt) {
        this.resolution = this.jCheckBox2.isSelected() ? 1 : 2;
        this.calculateC_Space();
        this.repaint();
        this.updateTorus();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.calculateC_Space();
        this.repaint();
        this.updateTorus();
        this.jTextField1.setText("0");
        this.jTextField2.setText("0");
        this.jTextField3.setText("0");
        this.jTextField4.setText("0");
    }

    private void jPanel1KeyPressed(KeyEvent evt) {
    }

    private void jPanel1KeyReleased(KeyEvent evt) {
    }

    private void jPanel1MouseClicked(MouseEvent evt) {
        double q1;
        double q2;
        double s2;
        double c2;
        Point pose_inv;
        if (evt.getButton() == 1) {
            pose_inv = new Point(evt.getX() - 180, evt.getY() - 180);
            c2 = (Math.pow(pose_inv.getX(), 2.0) + Math.pow(pose_inv.getY(), 2.0) - Math.pow(this.Robot.getLinkLength_1(), 2.0) - Math.pow(this.Robot.getLinkLength_2(), 2.0)) / (2.0 * this.Robot.getLinkLength_1() * this.Robot.getLinkLength_2());
            s2 = Math.sqrt(1.0 - Math.pow(c2, 2.0));
            q2 = Math.atan2(s2, c2);
            q1 = Math.atan2(pose_inv.getY(), pose_inv.getX()) - Math.atan2(this.Robot.getLinkLength_2() * s2, this.Robot.getLinkLength_1() + this.Robot.getLinkLength_2() * c2);
            q1 = -Math.toDegrees(q1);
            q2 = -Math.toDegrees(q2);
            this.Robot.setConfig((int)q1, (int)q2);
            if (q1 < 0.0) {
                q1 = 359.0 + q1;
            }
            if (q2 < 0.0) {
                q2 = 359.0 + q2;
            }
            this.jSlider2.setValue((int)q1);
            this.jSlider3.setValue((int)q2);
            this.repaint();
        }
        if (evt.getButton() == 3) {
            pose_inv = new Point(evt.getX() - 180, evt.getY() - 180);
            c2 = (Math.pow(pose_inv.getX(), 2.0) + Math.pow(pose_inv.getY(), 2.0) - Math.pow(this.Robot.getLinkLength_1(), 2.0) - Math.pow(this.Robot.getLinkLength_2(), 2.0)) / (2.0 * this.Robot.getLinkLength_1() * this.Robot.getLinkLength_2());
            s2 = -Math.sqrt(1.0 - Math.pow(c2, 2.0));
            q2 = Math.atan2(s2, c2);
            q1 = Math.atan2(pose_inv.getY(), pose_inv.getX()) - Math.atan2(this.Robot.getLinkLength_2() * s2, this.Robot.getLinkLength_1() + this.Robot.getLinkLength_2() * c2);
            q1 = -Math.toDegrees(q1);
            q2 = -Math.toDegrees(q2);
            this.Robot.setConfig((int)q1, (int)q2);
            if (q1 < 0.0) {
                q1 = 359.0 + q1;
            }
            if (q2 < 0.0) {
                q2 = 359.0 + q2;
            }
            this.jSlider2.setValue((int)q1);
            this.jSlider3.setValue((int)q2);
            this.repaint();
        }
    }

    private void calculateC_Space() {
        this.c_space = new BufferedImage(360, 360, 1);
        for (int i = 1; i <= 360; i += this.resolution) {
            for (int j = 1; j <= 360; j += this.resolution) {
                this.c_space.setRGB(i - 1, j - 1, 0xFFFFFF);
                this.c_space_torus.setRGB(i - 1, j - 1, this.gradient.getRGB(i - 1, j - 1));
                this.Robot.setConfig(i, j);
                if (this.jCheckBoxTri.isSelected()) {
                    if (this.triangle.inCollision(this.Robot.Link2)) {
                        this.c_space.setRGB(i - 1, j - 1, 65535);
                        this.c_space_torus.setRGB(i - 1, j - 1, 65535);
                    }
                    if (this.triangle.inCollision(this.Robot.Link1)) {
                        this.c_space.setRGB(i - 1, j - 1, 65535);
                        this.c_space_torus.setRGB(i - 1, j - 1, 65535);
                    }
                }
                if (this.jCheckBoxQuad.isSelected()) {
                    if (this.rectangle.inCollision(this.Robot.Link2)) {
                        this.c_space.setRGB(i - 1, j - 1, 0xFF00FF & this.c_space.getRGB(i - 1, j - 1));
                        this.c_space_torus.setRGB(i - 1, j - 1, 0xFF00FF & this.c_space.getRGB(i - 1, j - 1));
                    }
                    if (this.rectangle.inCollision(this.Robot.Link1)) {
                        this.c_space.setRGB(i - 1, j - 1, 0xFF00FF & this.c_space.getRGB(i - 1, j - 1));
                        this.c_space_torus.setRGB(i - 1, j - 1, 0xFF00FF & this.c_space.getRGB(i - 1, j - 1));
                    }
                }
                if (this.jCheckBoxCirc1.isSelected()) {
                    if (this.circle1.inCollision(this.Robot.Link2)) {
                        this.c_space.setRGB(i - 1, j - 1, 0xFFFF00 & this.c_space.getRGB(i - 1, j - 1));
                        this.c_space_torus.setRGB(i - 1, j - 1, 0xFFFF00 & this.c_space.getRGB(i - 1, j - 1));
                    }
                    if (this.circle1.inCollision(this.Robot.Link1)) {
                        this.c_space.setRGB(i - 1, j - 1, 0xFFFF00 & this.c_space.getRGB(i - 1, j - 1));
                        this.c_space_torus.setRGB(i - 1, j - 1, 0xFFFF00 & this.c_space.getRGB(i - 1, j - 1));
                    }
                }
                if (this.jCheckBoxCirc2.isSelected()) {
                    if (this.circle2.inCollision(this.Robot.Link2)) {
                        this.c_space.setRGB(i - 1, j - 1, 0x797979);
                        this.c_space_torus.setRGB(i - 1, j - 1, 0x797979);
                    }
                    if (this.circle2.inCollision(this.Robot.Link1)) {
                        this.c_space.setRGB(i - 1, j - 1, 0x797979);
                        this.c_space_torus.setRGB(i - 1, j - 1, 0x797979);
                    }
                }
                if (this.jCheckBoxCirc3.isSelected()) {
                    if (this.circle3.inCollision(this.Robot.Link2)) {
                        this.c_space.setRGB(i - 1, j - 1, 0x797979);
                        this.c_space_torus.setRGB(i - 1, j - 1, 0x797979);
                    }
                    if (this.circle3.inCollision(this.Robot.Link1)) {
                        this.c_space.setRGB(i - 1, j - 1, 0x797979);
                        this.c_space_torus.setRGB(i - 1, j - 1, 0x797979);
                    }
                }
                if (this.resolution == 1) continue;
                if (i < 360 && j < 360) {
                    this.c_space.setRGB(i, j, this.c_space.getRGB(i - 1, j - 1));
                }
                if (i < 360) {
                    this.c_space.setRGB(i, j - 1, this.c_space.getRGB(i - 1, j - 1));
                }
                if (j < 360) {
                    this.c_space.setRGB(i - 1, j, this.c_space.getRGB(i - 1, j - 1));
                }
                if (i < 360 && j < 360) {
                    this.c_space_torus.setRGB(i, j, this.c_space_torus.getRGB(i - 1, j - 1));
                }
                if (i < 360) {
                    this.c_space_torus.setRGB(i, j - 1, this.c_space_torus.getRGB(i - 1, j - 1));
                }
                if (j >= 360) continue;
                this.c_space_torus.setRGB(i - 1, j, this.c_space_torus.getRGB(i - 1, j - 1));
            }
        }
        ImageIcon icon = new ImageIcon();
        icon.setImage(this.c_space);
        this.jLabel_c_space.setIcon(icon);
    }

    private void makeTorus() {
        try {
            this.torus_flag = 1;
            this.canvas = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
            this.t1 = GUI.getSceneFromFile();
            this.app = new Appearance();
            this.app.setCapability(3);
            this.texLoader = new TextureLoader((Image)this.c_space, (Component)new Container());
            this.tex = this.texLoader.getTexture();
            this.app.setTexture(this.tex);
            this.root = this.t1.getSceneGroup();
            this.root.setCapability(12);
            this.torus = (Shape3D)this.root.getChild(0);
            this.torus.setCapability(15);
            this.torus.setAppearance(this.app);
            this.universe = new SimpleUniverse(this.canvas);
            this.universe.getViewingPlatform().setNominalViewingTransform();
            this.universe.addBranchGraph(this.root);
            this.universe.getViewingPlatform().setNominalViewingTransform();
            ViewingPlatform viewingPlatform = this.universe.getViewingPlatform();
            OrbitBehavior orbit = new OrbitBehavior(this.canvas, 368);
            BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0);
            orbit.setSchedulingBounds((Bounds)bounds);
            viewingPlatform.setNominalViewingTransform();
            viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
            this.canvas.setSize(this.jPanel2.getSize().width, this.jPanel2.getSize().height);
            this.jPanel2.add((Component)this.canvas);
        }
        catch (IOException ex) {
            Logger.getLogger(GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static Scene getSceneFromFile() throws IOException {
        ObjectFile file = new ObjectFile(64);
        return file.load(GUI.class.getClassLoader().getResource("torus/torus2.obj"));
    }

    public void updateTorus() {
        if (this.torus_flag == 1) {
            if (this.c_space_auto_update.isSelected()) {
                this.tex = new TextureLoader((Image)this.c_space_torus, (Component)new Container()).getTexture();
            }
            if (!this.c_space_auto_update.isSelected()) {
                this.tex = new TextureLoader((Image)this.gradient, (Component)new Container()).getTexture();
            }
            this.app.setTexture(this.tex);
            this.root = this.t1.getSceneGroup();
            this.torus = (Shape3D)this.root.getChild(0);
            this.torus.setAppearance(this.app);
        }
    }

    public void plotPath(ArrayList<Configuration> _path) {
        for (int i = 0; i < _path.size() - 1; ++i) {
            this.plotLocalPath(_path.get(i), _path.get(i + 1));
        }
    }

    public void plotTree(NodeSet<Configuration> n_s) {
        for (RiccardoTree<Configuration> next : n_s.getSet()) {
            if (next.isRoot()) continue;
            Configuration parentNode = next.getParent().getObjectNode();
            Configuration thisNode = next.getObjectNode();
            this.plotLocalPath(thisNode, parentNode);
        }
    }

    public void plotLocalPath(Configuration _init, Configuration _goal) {
        Configuration[] localPath = PlanningTools.getDirectPath(_init, _goal);
        for (int j = 0; j < localPath.length; ++j) {
            this.plotConfiguration(localPath[j]);
        }
    }

    public void plotConfiguration(Configuration c) {
        Point pose = new Point(c.theta1, c.theta2);
        if (this.jCheckBox1.isSelected() && pose.x < 359 && pose.x > 1 && pose.y < 359 && pose.y > 1) {
            this.c_space.setRGB(pose.x, pose.y, 0);
            this.c_space_torus.setRGB(pose.x, pose.y, 0);
            this.c_space_torus.setRGB(pose.x - 1, pose.y, 0);
            this.c_space_torus.setRGB(pose.x + 1, pose.y, 0);
            this.c_space_torus.setRGB(pose.x, pose.y - 1, 0);
            this.c_space_torus.setRGB(pose.x, pose.y + 1, 0);
        }
    }

    public void setRedDotRobotPose(int x, int y) {
        int newX = x + this.jLabel_c_space.getX();
        int newY = y + this.jLabel_c_space.getY();
        this.jLabel_Red_Dot_Robot.setLocation(newX - 2, newY - 2);
    }

    public void showRobotAsRedDot(int x, int y) {
        if (x < 359 && x > 1 && y < 359 && y > 1) {
            this.c_space_torus.setRGB(this.x_red_robot_old, this.y_red_robot_old, this.old_colors_torus_cSpace[0]);
            this.c_space_torus.setRGB(this.x_red_robot_old - 1, this.y_red_robot_old, this.old_colors_torus_cSpace[1]);
            this.c_space_torus.setRGB(this.x_red_robot_old + 1, this.y_red_robot_old, this.old_colors_torus_cSpace[2]);
            this.c_space_torus.setRGB(this.x_red_robot_old, this.y_red_robot_old - 1, this.old_colors_torus_cSpace[3]);
            this.c_space_torus.setRGB(this.x_red_robot_old, this.y_red_robot_old + 1, this.old_colors_torus_cSpace[4]);
            this.c_space_torus.setRGB(this.x_red_robot_old - 1, this.y_red_robot_old - 1, this.old_colors_torus_cSpace[5]);
            this.c_space_torus.setRGB(this.x_red_robot_old + 1, this.y_red_robot_old + 1, this.old_colors_torus_cSpace[6]);
            this.c_space_torus.setRGB(this.x_red_robot_old + 1, this.y_red_robot_old - 1, this.old_colors_torus_cSpace[7]);
            this.c_space_torus.setRGB(this.x_red_robot_old - 1, this.y_red_robot_old + 1, this.old_colors_torus_cSpace[8]);
            this.x_red_robot_old = x;
            this.y_red_robot_old = y;
            this.old_colors_torus_cSpace[0] = this.c_space_torus.getRGB(x, y);
            this.c_space_torus.setRGB(x, y, 0xFF0000);
            this.old_colors_torus_cSpace[1] = this.c_space_torus.getRGB(x - 1, y);
            this.c_space_torus.setRGB(x - 1, y, 0xFF0000);
            this.old_colors_torus_cSpace[2] = this.c_space_torus.getRGB(x + 1, y);
            this.c_space_torus.setRGB(x + 1, y, 0xFF0000);
            this.old_colors_torus_cSpace[3] = this.c_space_torus.getRGB(x, y - 1);
            this.c_space_torus.setRGB(x, y - 1, 0xFF0000);
            this.old_colors_torus_cSpace[4] = this.c_space_torus.getRGB(x, y + 1);
            this.c_space_torus.setRGB(x, y + 1, 0xFF0000);
            this.old_colors_torus_cSpace[5] = this.c_space_torus.getRGB(x - 1, y - 1);
            this.c_space_torus.setRGB(x - 1, y - 1, 0xFF0000);
            this.old_colors_torus_cSpace[6] = this.c_space_torus.getRGB(x + 1, y + 1);
            this.c_space_torus.setRGB(x + 1, y + 1, 0xFF0000);
            this.old_colors_torus_cSpace[7] = this.c_space_torus.getRGB(x + 1, y - 1);
            this.c_space_torus.setRGB(x + 1, y - 1, 0xFF0000);
            this.old_colors_torus_cSpace[8] = this.c_space_torus.getRGB(x - 1, y + 1);
            this.c_space_torus.setRGB(x - 1, y + 1, 0xFF0000);
            this.updateTorus();
        }
    }

    public void showQiQf(Configuration QI, Configuration QG) {
        Point pose = new Point(QI.theta1, QI.theta2);
        this.c_space.setRGB(pose.x, pose.y, 255);
        this.c_space.setRGB(pose.x - 1, pose.y, 255);
        this.c_space.setRGB(pose.x + 1, pose.y, 255);
        this.c_space.setRGB(pose.x, pose.y - 1, 255);
        this.c_space.setRGB(pose.x, pose.y + 1, 255);
        this.c_space.setRGB(pose.x - 1, pose.y - 1, 255);
        this.c_space.setRGB(pose.x + 1, pose.y + 1, 255);
        this.c_space.setRGB(pose.x + 1, pose.y - 1, 255);
        this.c_space.setRGB(pose.x - 1, pose.y + 1, 255);
        pose.setLocation(QG.theta1, QG.theta2);
        this.c_space.setRGB(pose.x, pose.y, 65280);
        this.c_space.setRGB(pose.x - 1, pose.y, 65280);
        this.c_space.setRGB(pose.x + 1, pose.y, 65280);
        this.c_space.setRGB(pose.x, pose.y - 1, 65280);
        this.c_space.setRGB(pose.x, pose.y + 1, 65280);
        this.c_space.setRGB(pose.x - 1, pose.y - 1, 65280);
        this.c_space.setRGB(pose.x + 1, pose.y + 1, 65280);
        this.c_space.setRGB(pose.x + 1, pose.y - 1, 65280);
        this.c_space.setRGB(pose.x - 1, pose.y + 1, 65280);
    }
}

