package processo;

import emergenza.Area;
import gui.*;

import java.util.*;

import _framework.Executor;

public class AttivitaPrincipale implements Runnable 
{
	private List<RecordArea> insieme;
	private boolean eseguito=false;

	public synchronized void run() 
	{
		if (eseguito)
			return;
		eseguito=true;
		insieme=AttivitaIO.inserisciInfoArea();
		AggiornaInfoAree aggInfo=new AggiornaInfoAree(insieme);
		Executor.perform(aggInfo);
		LinkedList<Thread> lista=new LinkedList<Thread>();
		Iterator<RecordArea> iter=insieme.iterator();
		while(iter.hasNext())
		{
			Thread t=new Thread(new GestioneArea(iter.next()));
			t.start();
			lista.add(t);
		}
		Iterator<Thread> iterThr=lista.iterator();
		try 
		{		
			while(iterThr.hasNext())
				iterThr.next().join();

		} 
		catch (InterruptedException e) 
		{
			e.printStackTrace();
			System.exit(1);
		}
		RecordArea area;
		do
		{
			area=AttivitaIO.inserisciNomeArea(insieme);
			if (area!=null)
			{
				CalcolaStatistica calc=new CalcolaStatistica(area);
				Executor.perform(calc);
				AttivitaIO.visualizzaStatistiche(area,
						calc.getPercentualiFeriti(),calc.getPercentualiVittime());
			}
		} while(area!=null);
	}
}
