package processo;

import java.util.Iterator;
import java.util.List;
import emergenza.*;

import gui.RecordPersona;
import _framework.Executor;
import _framework.Task;

public class AggiornaInfoEdifici implements Task 
{
	private String indirizzo;
	private List<RecordPersona> recQuest;

	public AggiornaInfoEdifici(String indirizzo, List<RecordPersona> recQuest) {
		this.indirizzo=indirizzo;
		this.recQuest=recQuest;
	}

	public void esegui(Executor e) 
	{
		try {
			Iterator<RecordPersona> iter = recQuest.iterator();
			Edificio edif = Modello.getEdificioByIndirizzo(indirizzo);
			while (iter.hasNext()) {
				RecordPersona recP = iter.next();
				Persona pers;
				if (recP.isVivo()) {
					pers = new PersonaSuperstite(recP.getEta(), recP.getNominativo());
					if (recP.getNomeOspedale()!=null)
					{
						Ospedale osp=Modello.getOspedaleByNome(recP.getNomeOspedale());
						if (osp!=null)
						{
							((PersonaSuperstite)pers).inserisciLink(
									new TipoLinkRicovero(((PersonaSuperstite)pers),osp));
						}
					}
				}
				else
					pers = new PersonaVittima(recP.getEta(), recP.getNominativo());
				edif.inserisciLinkComprende(new TipoLinkCollocazione(pers,edif));
			}
		} 
		catch (EccezionePrecondizioni e2) 
		{
			e2.printStackTrace();
			System.exit(1);
		}
	}

}
