package colonie;

import java.util.*;

public class Regione {
	private final String nome;
	private final HashSet<TipoLinkContiene> contiene;
	
	private final int CARD_MIN_CONTIENE=4;
	
	public Regione(String nome){
		this.nome=nome;
		contiene = new HashSet<TipoLinkContiene>();
	}
	
	public String getNome(){
		return nome;
	}
	
	public Set<TipoLinkContiene> getContiene() throws EccezioneCardMinMax{
		if (contiene.size()<CARD_MIN_CONTIENE)
			throw new EccezioneCardMinMax("Cardinalita' minima violata");
		return (Set<TipoLinkContiene>) contiene;
	}
	
	public void inserisciLinkContiene(TipoLinkContiene l){	
		if (l != null && l.getRegione() == this){
			ManagerContiene.inserisci(l);
		}
	}
	
	public void inserisciPerManagerContiene(ManagerContiene m){
		if (m != null){
			contiene.add(m.getLink());
		}
	}
	
	public void eliminaLinkContiene(TipoLinkContiene l){	
		if (l != null && l.getRegione() == this){
			ManagerContiene.elimina(l);
		}
	}
	
	public void eliminaPerManagerContiene(ManagerContiene m){
		if (m != null){
			contiene.remove(m.getLink());
		}
	}
	
}
