package attivitaatomiche;

import java.util.*;
import colonie.*;
import colonie.colonia.*;
import eventi.Popola;
import eventi.Svuota;
import _framework.*;
import _gestioneeventi.*;
import gui.*;

public class InizializzaEnvironment implements Task {
	private boolean eseguita = false;
	private Regione regione;
	private Set<Colonia> coloniePopolate;

	public InizializzaEnvironment(Regione regione, Set<Colonia> coloniePopolate) {
		this.regione=regione;
		this.coloniePopolate=coloniePopolate;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita)
			return;
		eseguita = true;
		
		Set<TipoLinkContiene> colonie = null;
		try{
			colonie=regione.getContiene();
		}
		catch (EccezioneCardMinMax ecc){
			ecc.printStackTrace();
			System.exit(1);
		}
		Colonia coloniaCorrente = null;
		Iterator<TipoLinkContiene> itColonie = colonie.iterator();
		while(itColonie.hasNext()){
			coloniaCorrente = itColonie.next().getColonia();
			EsecuzioneEnvironment.addListener(coloniaCorrente);
			if (coloniePopolate.contains(coloniaCorrente)){
				coloniaCorrente.inizializza(Colonia.Stato.POPOLATA);
				Environment.aggiungiEvento(new Evento(null,coloniaCorrente));
			}
			else{
				coloniaCorrente.inizializza(Colonia.Stato.DESERTA);
				Environment.aggiungiEvento(new Evento(null,coloniaCorrente));								
			}
		}		
	}
}
