package attivitaatomiche;


import java.util.Iterator;
import java.util.Set;

import colonie.*;
import colonie.colonia.Colonia;
import _framework.*;

public class ContaColoniePopolate implements Task {
	private Regione regione;
	private boolean eseguita = false;
	private int quanteColoniePopolate=0;
	
	
	public ContaColoniePopolate(Regione regione) {
		this.regione = regione;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita)
			return;
		eseguita = true;
		quanteColoniePopolate = quanteColoniePopolate(regione);
	}
	
	public synchronized int getRisultato(){
		return quanteColoniePopolate;
	}
	
	private int quanteColoniePopolate(Regione regione){
		// metodo ausiliario per il conto delle colonie popolate
		// metodo non sincronizzato perche' interno alla classe. Sara' invocato solo all'interno di un metodo sincronizzato.
		int risultato=0;
		Set<TipoLinkContiene> contiene = null;
		try{
			contiene = regione.getContiene();
		}
		catch (EccezioneCardMinMax ecc){
			ecc.printStackTrace();
			System.exit(1);
		}
		Iterator<TipoLinkContiene> itContiene = contiene.iterator();
		while (itContiene.hasNext()){
			if (itContiene.next().getColonia().getStato() == Colonia.Stato.POPOLATA)
				risultato++;
		}
		return risultato;
	}
}
