package gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import _gestioneeventi.*;
import colonie.*;
import colonie.colonia.*;

import java.util.*;

import it.uniroma1.dis.grafica.*;

class Griglia extends DrawPanel{// NB: non pubblica perch ad uso interno del package
	private final int LATO_CASELLA = 30;
	private final int SPESSORE_LINEA = 3;
	private final int MARGINE = 10;
	private final FinestraRegione finestraRegione;
	private int lato;// numero di caselle per lato
	private boolean impostazioneManualeAbilitata = true;
	private Figure[][] statoCelle;// Associa ogni coordinata alla figura (null o quadrato giallo) in essa contenuta
	private Map <Colonia,Point> colonie2coord;// Solo per scopi grafici, associa le colonie alle rispettive coordinate nella griglia
	
	public Griglia(int lato, FinestraRegione finestraRegione, Regione regione){
		this.lato = lato;
		this.finestraRegione = finestraRegione;
		statoCelle = new Figure[lato][lato];// se la componente (i,j)	non contiene figure, la colonia e' deserta; altrimenti e' popolata
		for (int j=0; j<=lato; j++){
			
			//Riga orizzontale
			Point start = new Point(MARGINE,j*LATO_CASELLA+MARGINE);
			Point end = new Point((lato*LATO_CASELLA)+MARGINE,j*LATO_CASELLA+MARGINE);
			Line l=new Line(start, end);
			l.setLineSize(SPESSORE_LINEA);
			addFigureBatch(l);
			
			//Riga verticale
			start = new Point(j*LATO_CASELLA+MARGINE,MARGINE);
			end = new Point((j*LATO_CASELLA)+MARGINE,(lato*LATO_CASELLA)+MARGINE);
			l=new Line(start, end);
			l.setLineSize(SPESSORE_LINEA);
			addFigureBatch(l);
			commit();
		}
		
		for (int i=0; i<lato; i++){
			for (int j=0; j<lato; j++){
				statoCelle[i][j]=null;
			}
		}
		
		colonie2coord = new HashMap<Colonia,Point>();
		//Inizializza la mappa colonia->coordinate
		Set<TipoLinkContiene> colonie = null;
		try{
			colonie=regione.getContiene();
		}
		catch (EccezioneCardMinMax ecc){
			ecc.printStackTrace();
			System.exit(1);
		}
		Colonia coloniaCorrente = null;
		Iterator<TipoLinkContiene> itColonie = colonie.iterator();// prima colonia scelta random
		if (itColonie.hasNext()){
			coloniaCorrente = itColonie.next().getColonia();// seleziona una colonia qualsiasi
		}

		// Si posiziona sulla colonia (0,0)
		while(coloniaCorrente.getLinkNord() != null){
			coloniaCorrente = coloniaCorrente.getLinkNord().getNord();
		}
		while(coloniaCorrente.getLinkOvest() != null){
			coloniaCorrente = coloniaCorrente.getLinkOvest().getOvest();
		}
		// coloniaCorrente e' la colonia a nord-ovest estremo
		for (int i=0;i<lato;i++){
			Colonia inizioColonna = coloniaCorrente;
			for (int j=0; j<lato; j++){
				colonie2coord.put(coloniaCorrente,new Point(i,j));
				if(coloniaCorrente.getLinkSud() != null)
					coloniaCorrente = coloniaCorrente.getLinkSud().getSud();
				else if (inizioColonna.getLinkEst()!=null){					
					coloniaCorrente = inizioColonna.getLinkEst().getEst();
				}
			}
		}				
		addMouseListener(new ListenerGriglia());
	}
	
	public void disabilitaImpostazioneManuale(){
		impostazioneManualeAbilitata=false;
	}
	
	private boolean coordinateNonValide(int i, int j){
		return (i< MARGINE || j< MARGINE || i >= lato*LATO_CASELLA+MARGINE || j >= lato*LATO_CASELLA+MARGINE);
	}
	
	private int normalizza(int x){
		return (x-MARGINE) / LATO_CASELLA;
	}
	
	private void toggleCella(int i, int j){
		// cambia lo stato corrente della cella a cui appartiene il punto di coordinate (i,j) passato per parametro
		if (!impostazioneManualeAbilitata || coordinateNonValide(i,j))
			return;
		i = normalizza(i);
		j = normalizza(j);
		
		// Individua la cella associata alle coordinate passate in input
		Colonia colonia=null;
		Set<Colonia> colonie2coordKeys = colonie2coord.keySet();
		Iterator<Colonia> itColonia = colonie2coordKeys.iterator();
		while(itColonia.hasNext() && colonia == null){
			Colonia coloniaCorrente = itColonia.next();
			if(colonie2coord.get(coloniaCorrente).x == i && colonie2coord.get(coloniaCorrente).y == j)
				colonia = coloniaCorrente;
		}
		if (colonia == null)
			return;

		if(statoCelle[i][j]==null){//La colonia era deserta e deve essere popolata (colorata)
			accendiCella(colonia);
		}
		else{//La colonia era popolata e deve essere svuotata
			spegniCella(colonia);
		}
	}
	
	public void accendiCella(Colonia c){// Accende la cella relativa alla colonia passata in input
		int i = (int) colonie2coord.get(c).getX();
		int j = (int) colonie2coord.get(c).getY();
		
		if (statoCelle[i][j] != null)// accende solo se non lo e' gia'
			return;
		
		// colora la cella (i,j)
		Point[] angoliCella = new Point[4];
		// imposta i punti
		angoliCella[0]=new Point(i*LATO_CASELLA+MARGINE+SPESSORE_LINEA-1,j*LATO_CASELLA+MARGINE+SPESSORE_LINEA-1);
		angoliCella[1]=new Point((i+1)*LATO_CASELLA+MARGINE-1,j*LATO_CASELLA+MARGINE+SPESSORE_LINEA-1);
		angoliCella[2]=new Point((i+1)*LATO_CASELLA+MARGINE-1,(j+1)*LATO_CASELLA+MARGINE-1);
		angoliCella[3]=new Point(i*LATO_CASELLA+MARGINE+SPESSORE_LINEA-1,(j+1)*LATO_CASELLA+MARGINE-1);
		MyPolygon cellaColorata = new MyPolygon(angoliCella,true);
		cellaColorata.setFillColor(Color.YELLOW);
		addFigureBatch(cellaColorata);
		
		statoCelle[i][j]=cellaColorata;
		commit();
	}	
	
	public void spegniCella(Colonia c){
		int i = (int) colonie2coord.get(c).getX();
		int j = (int) colonie2coord.get(c).getY();

		if (statoCelle[i][j] == null)// spegne solo se non lo e' gia'
			return;

		
		removeFigure(statoCelle[i][j]);
		statoCelle[i][j]=null;
		commit();
	}
	
	@Override
	public Dimension getPreferredSize(){
		return(new Dimension(lato*LATO_CASELLA+2*MARGINE,lato*LATO_CASELLA+2*MARGINE));
	}
	
	public Set<Colonia> getStatoColonie(){
		//Restituisce l'insieme delle colonie le cui celle sono accese
		Set<Colonia> risultato = new HashSet<Colonia>();
		Set<Colonia> colonie2coordKeys = colonie2coord.keySet();
		
		Iterator<Colonia> itColonia = colonie2coordKeys.iterator();
		while(itColonia.hasNext()){
			Colonia coloniaCorrente = itColonia.next();
			if(statoCelle[colonie2coord.get(coloniaCorrente).x][colonie2coord.get(coloniaCorrente).y] != null)
				risultato.add(coloniaCorrente);
		}
		return risultato;
	}
	
	
	//Inner class
	class ListenerGriglia implements MouseListener{		
		public void mouseClicked(MouseEvent e){
			toggleCella(e.getX(), e.getY());
			commit();
		}
		
		// I metodi seguenti non fanno nulla, ma devono essere comunque implementati
		public void mousePressed(MouseEvent e){}
		public void mouseReleased(MouseEvent e){}
		public void mouseEntered(MouseEvent e){}
		public void mouseExited(MouseEvent e){}
	}	
}






